function initEditor() {
  tinymce.init({
    language: "pt_BR",
    entity_encoding: "named",
    selector: ".editor",
    setup: function (editor) {
      editor.on("change", function () {
        editor.save();
      });
    },
    theme: "modern",
    height: 200,
    plugins: [
      "advlist autolink link image lists charmap print preview hr anchor pagebreak",
      "searchreplace wordcount visualblocks visualchars insertdatetime media nonbreaking",
      "table contextmenu directionality emoticons paste textcolor code fullscreen spellchecker",
    ],
    toolbar1:
      "undo redo | styleselect | bold italic underline | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | table | fullscreen |",
    toolbar2:
      "| responsivefilemanager image media | link unlink anchor | print preview code |  nanospell",
    image_advtab: true,
    menubar: "false",
    external_plugins: { nanospell: "nanospell/plugin.js" },
    nanospell_server: "php",
    nanospell_dictionary: "pt_br",
  });
}

function init_calendar() {
  $(".ui.calendar").calendar({
    today: true,
    type: "date",
    monthFirst: false,
    formatter: {
      date: function (date, settings) {
        if (!date) return "";
        var day = date.getDate() + "";
        if (day.length < 2) {
          day = "0" + day;
        }
        var month = date.getMonth() + 1 + "";
        if (month.length < 2) {
          month = "0" + month;
        }
        var year = date.getFullYear();
        return day + "/" + month + "/" + year;
      },
    },
    text: {
      days: ["D", "S", "T", "Q", "Q", "S", "S"],
      dayNamesShort: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
      dayNames: [
        "Domingo",
        "Segunda",
        "Terça",
        "Quarta",
        "Quinta",
        "Sexta",
        "Sábado",
      ],
      months: [
        "Janeiro",
        "Fevereiro",
        "Março",
        "Abril",
        "Maio",
        "Junho",
        "Julho",
        "Agosto",
        "Setembro",
        "Outubro",
        "Novembro",
        "Dezembro",
      ],
      monthsShort: [
        "Jan",
        "Fev",
        "Mar",
        "Abr",
        "Mai",
        "Jun",
        "Jul",
        "Ago",
        "Set",
        "Out",
        "Nov",
        "Dez",
      ],
      today: "Hoje",
      now: "Agora",
      am: "AM",
      pm: "PM",
      weekNo: "Semana",
    },
  });
}

function extendDataTables() {
  jQuery.extend(jQuery.fn.dataTableExt.oSort, {
    "date-br-pre": function (a) {
      var x;
      if ($.trim(a) !== "") {
        var frDatea = $.trim(a).split(" ");
        var frTimea =
          undefined != frDatea[1] ? frDatea[1].split(":") : [00, 00, 00];
        var frDatea2 = frDatea[0].split("/");
        x =
          (frDatea2[2] +
            frDatea2[1] +
            frDatea2[0] +
            frTimea[0] +
            frTimea[1] +
            (undefined != frTimea[2] ? frTimea[2] : 0)) *
          1;
      } else {
        x = Infinity;
      }
      return x;
    },
    "date-br-asc": function (a, b) {
      return a - b;
    },
    "date-br-desc": function (a, b) {
      return b - a;
    },
  });
}

function uppercase_fields() {
  $("input[type='text']:not(.minusculo)").on("keyup", function (event) {
    var start = this.selectionStart;
    var end = this.selectionEnd;
    this.value = this.value.toUpperCase();
    this.setSelectionRange(start, end);
  });
}
function init_plugin_mask() {
  extendDataTables();
  initEditor();
  init_calendar();
  uppercase_fields();
  $(".date").mask("00/00/0000", {
    placeholder: "00/00/0000",
    selectOnFocus: true,
    clearIfNotMatch: true,
  });
  $(".time").mask("00:00:00", {
    placeholder: "00:00:00",
    selectOnFocus: true,
    clearIfNotMatch: true,
  });
  $(".date_time").mask("00/00/0000 00:00", {
    placeholder: "00/00/0000 00:00",
    selectOnFocus: true,
    clearIfNotMatch: true,
  });
  $(".cep").mask("00000-000", {
    placeholder: "00000-000",
    selectOnFocus: true,
    clearIfNotMatch: true,
  });
  $(".mixed").mask("AAA 000-S0S", { selectOnFocus: true });
  $(".serial").mask("SSSS-0000-000000", { selectOnFocus: true });
  $(".number").mask("##0", { reverse: true, selectOnFocus: true });
  $(".cpf").mask(
    "000.000.000-00",
    { placeholder: "000.000.000-00" },
    { reverse: true, selectOnFocus: true, clearIfNotMatch: true }
  );
  $(".inscricao").mask(
    "00.000.000-0",
    { placeholder: "00.000.000-0" },
    { reverse: true, selectOnFocus: true, clearIfNotMatch: true }
  );
  $(".cnpj").mask(
    "00.000.000/0000-00",
    { placeholder: "00.000.000/0000-00" },
    { reverse: true, selectOnFocus: true, clearIfNotMatch: true }
  );
  $(".money").mask("000.000.000.000.000,00", {
    placeholder: "R$ 000.000,00",
    reverse: true,
    selectOnFocus: true,
  });
  $(".money2").mask("#.##0,00", { reverse: true, selectOnFocus: true });
  $(".percent").mask("##0.00", {
    reverse: true,
    selectOnFocus: true,
    placeholder: "100.00",
  });
  $(".ipv4").mask("099.099.099.099", {
    selectOnFocus: true,
    clearIfNotMatch: true,
  });

  var PhoneMask = function (val) {
    return val.replace(/\D/g, "").length === 11
      ? "(00) 00000-0000"
      : "(00) 0000-00009";
  };
  var PhoneMaskOptions = {
    onKeyPress: function (val, e, field, options) {
      field.mask(PhoneMask.apply({}, arguments), options);
    },
    placeholder: "(00) X0000-0000",
    clearIfNotMatch: true,
  };
  $(".phone").mask(PhoneMask, PhoneMaskOptions);
}
