<?php

////////////////////////////// TRANSLATE FUNCTION //////////////////////////////////////////////////

function i18n($t_list, $key, $return = false)
{
	$result = "";
	if (array_key_exists($key, $t_list)) {
		$result = $t_list[$key];
	} else {
		$result = 'Tradução não encontrada';
	}
	if ($return) {
		return $result;
	} else {
		echo $result;
	}
}

$act_list = array(
	"logout"    => "Sair",
	"new"    => "Novo",
	"edit"   => "Editar",
	"action" => "Ação",
	"show"   => "Visualizar",
	"delete" => "Excluir",
	"next"   => "Avançar",
	"prev"   => "Voltar",
	"search"   => "Pesquisar",
	"results"   => "Resultado(s) encontrado(s)",
	"search_field"   => "Filtro",
	"attackment_not_found"   => "Anexo não encontrado"
);


//////////////////////////////////////////////////////////////////////////////////

function directory_export($folder_files, $folder_zip)
{
	if (!is_dir($folder_files)) {
		mkdir($folder_files,  0755, true);
	}

	if (!is_dir($folder_zip)) {
		mkdir($folder_zip,  0755, true);
	}

	//LIMPA A PASTA ANTES DE CRIAR OS ARQUIVOS
	if (is_dir($folder_files)) {
		$directory = dir($folder_files);
		while ($file = $directory->read()) {
			if ($file != "." && $file != "..") {
				unlink($folder_files . $file);
			}
		}
		$directory->close();
	} else {
		echo 'ERRO: A pasta não existe.';
		die();
	}

	if (is_dir($folder_zip)) {
		$directory = dir($folder_zip);
		while ($file = $directory->read()) {
			if ($file != "." && $file != "..") {
				unlink($folder_zip . $file);
			}
		}
		$directory->close();
	} else {
		echo 'ERRO: A pasta não existe.';
		die();
	}
}


//////////////////////////////////////////////////////////////////////////////////

function in_array_recursive($needle, $haystack, $strict = false)
{
	foreach ($haystack as $item) {
		if (($strict ? $item === $needle : $item == $needle) || (is_array($item) && in_array_recursive($needle, $item, $strict))) {
			return true;
		}
	}

	return false;
}

function reversespecialchars($string)
{
	$string = str_replace('&quot;', '"', $string);
	$string = str_replace('&amp;', '&', $string);
	$string = str_replace('&lt;', '<', $string);
	$string = str_replace('&gt;', '>', $string);
	$string = str_replace('&apos;', "'", $string);

	return $string;
}

////////////////////////////////////////////////////////////////////////////////

function make_log($dir, $output_file, $module, $user, $old_data, $new_data)
{

	$data_log = array(
		'MODULE' => $module,
		'USER' => $user,
		'NEW_DATA' => $new_data,
		'CREATED_AT' => date("Y-m-d h:i:s")
	);

	$msg = json_encode($data_log, JSON_UNESCAPED_UNICODE);

	if (!is_dir($dir)) {
		mkdir($dir,  0777, true);
	}

	$saved_file = fopen($dir . "/" . $output_file, "a");
	fwrite($saved_file, $msg . "," . PHP_EOL);
	fclose($saved_file);
}
////////////////////////////////////////////////////////////////////////////////

function BRL($value)
{ // CONVERTE VALOR EM REAIS
	return 'R$ ' . number_format($value, 2, ',', '.');
}
function BRL_INPUT($value)
{ // CONVERTE VALOR EM REAIS
	return number_format($value, 2, '.', '');
}

function removeEspecialCharsLink($string)
{
	$map = array(
		'á' => 'a',
		'à' => 'a',
		'ã' => 'a',
		'â' => 'a',
		'é' => 'e',
		'ê' => 'e',
		'í' => 'i',
		'ó' => 'o',
		'ô' => 'o',
		'õ' => 'o',
		'ú' => 'u',
		'ü' => 'u',
		'ç' => 'c',
		'Á' => 'A',
		'À' => 'A',
		'Ã' => 'A',
		'Â' => 'A',
		'É' => 'E',
		'Ê' => 'E',
		'Í' => 'I',
		'Ó' => 'O',
		'Ô' => 'O',
		'Õ' => 'O',
		'Ú' => 'U',
		'Ü' => 'U',
		'Ç' => 'C'
	);
	$string = strtr($string, $map);
	$string = preg_replace('/[^a-z0-9]/i', '_', $string);
	return $string;
}
function removeEspecialChars($string)
{
	$map = array(
		'º' => ' ',
		'ª' => ' ',
		'*' => ' ',
		'/' => ' ',
		'-' => ' ',
		'_' => ' ',
		'@' => ' ',
		'!' => ' ',
		',' => ' ',
		'\'' => ' ',
		'"' => ' ',
		'#' => ' ',
		'%' => ' ',
		'¨' => ' ',
		'¨' => ' ',
		'á' => 'a',
		'à' => 'a',
		'ã' => 'a',
		'â' => 'a',
		'é' => 'e',
		'ê' => 'e',
		'í' => 'i',
		'ó' => 'o',
		'ô' => 'o',
		'õ' => 'o',
		'ú' => 'u',
		'ü' => 'u',
		'ç' => 'c',
		'Á' => 'A',
		'À' => 'A',
		'Ã' => 'A',
		'Â' => 'A',
		'É' => 'E',
		'Ê' => 'E',
		'Í' => 'I',
		'Ó' => 'O',
		'Ô' => 'O',
		'Õ' => 'O',
		'Ú' => 'U',
		'Ü' => 'U',
		'Ç' => 'C'
	);
	$string = strtr($string, $map);
	return $string;
}


function removeDigits($var)
{
	$var = str_replace('.', '', $var);
	$var = str_replace('-', '', $var);
	$var = str_replace('/', '', $var);
	$var = str_replace('_', '', $var);
	$var = str_replace('(', '', $var);
	$var = str_replace(')', '', $var);
	$var = str_replace(' ', '', $var);
	return $var;
}

// Funções de Data
function getDateTimeNow()
{
	return date("Y-m-d H:i:s");
}
function ConvertDateToMysql($date)
{
	if ($date != null) {
		$d = $date;
		$dt = DateTime::createFromFormat('d/m/Y', $d);
		$dt = $dt->format('Y-m-d');
		return $dt;
	} else {
		return null;
	}
}
function getAnoMes($date)
{
	if ($date != null) {
		$d = $date;
		$dt = DateTime::createFromFormat('Y-m-d', $d);
		$dt = $dt->format('Y-m');
		return $dt;
	} else {
		return null;
	}
}
function ConvertDatetimeToMysql($date)
{
	if ($date != null) {
		$d = $date;
		if (strlen($d) > 16) {
			$dt = DateTime::createFromFormat('d/m/Y H:i:s', $d);
			$dt = $dt->format('Y-m-d H:i:s');
		} elseif (strlen($d) <= 16 && strlen($d) >= 14) {
			$dt = DateTime::createFromFormat('d/m/Y H:i', $d);
			$dt = $dt->format('Y-m-d H:i:00');
		} else {
			$dt = DateTime::createFromFormat('d/m/Y H', $d);
			$dt = $dt->format('Y-m-d H:00:00');
		}

		return $dt;
	} else {
		return null;
	}
}
function ConvertDatetimeFromMysql($date)
{
	if (is_null($date)) {
		echo "";
	} else {
		$date = new DateTime($date);
		return $date->format("d/m/Y H:i:s");
	}
}
function DataPadrao($date)
{
	if (is_null($date)) {
		echo "";
	} else {
		$dt = DateTime::createFromFormat('Y-m-d', $date);
		return $dt->format("d/m/Y");
	}
}
function getOnlyDay($date)
{
	$date = new DateTime($date);
	return $date->format("d");
}
function getOnlyMonth($date)
{
	$date = new DateTime($date);
	return $date->format("m");
}
function getOnlyYear($date)
{
	$date = new DateTime($date);
	return $date->format("Y");
}
function getOnlyMonthYear($date)
{
	if (is_null($date)) {
		return null;
	} else {
		$date = new DateTime($date);
		return $date->format("Y-m");
	}
}
function getOnlyDate($date, $br = false)
{
	if ($br) {
		$date = DateTime::createFromFormat('d/m/Y', $date);
	} else {
		$date = new DateTime($date);
	}
	return $date->format("Y-m-d");
}
function ConvertDateFromMysql($date)
{
	if (is_null($date)) {
		return null;
	} else {
		$date = new DateTime($date);
		return $date->format("d/m/Y");
	}
}
function ConvertToInt($var)
{
	$var = preg_replace('#[^0-9]#', '', $var);
	return $var;
}
function lastDayOfmonth($date)
{
	return date("Y-m-t", strtotime($date));
}

function ConvertFloatToMysql($var)
{
	$var = str_replace('.', '', $var);
	$var = str_replace(',', '.', $var);
	return $var;
}

// Fim das funções de data

function msg($type, $msg, $return = false)
{
	$mensagem = "";
	if ($type == "Success") {
		$mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
	} else if ($type == "Alert") {
		$mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
	} else if ($type == "Info") {
		$mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
	} else if ($type == "Error") {
		$mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
	} else {
		$mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
	}
	if ($return) {
		return $mensagem;
	} else {
		echo $mensagem;
	}
}
function errorPHP($type, $msg, $return = false)
{
	$mensagem = "";
	if ($type == "Alert") {
		if (strpos($msg, 'Undefined variable')) {
			$msg = str_replace("Undefined variable", "variável não definida: ", $msg);
		}
		$mensagem = '<div class="ui warning aligned message">' . $msg . '</div>';
	} else if ($type == "Error") {
		$mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
	}
	if ($return) {
		return $mensagem;
	} else {
		echo $mensagem;
	}
}


function ErrorSQL($msg)
{
	$sql_error["error_type"] = "sql";
	if (strpos($msg, 'foreign key')) {
		$sql_error["error_msg"] = "N&atilde;o foi possivel completar a opera&ccedil;&atilde;o, Chave estrangeira não encontrada ou existem outros registros utilizando este item.";
	} else if (strpos($msg, 'Duplicate entry')) {
		$sql_error["error_msg"] = "Há campo(s) duplicado(s) no banco de dados, por favor verifique os dados!";
	} else if (strpos($msg, 'cannot be null')) {
		$sql_error["error_msg"] = "Algum campo obrigatório não foi preenchido, por favor verifique os dados!";
	} else if (strpos($msg, 'Unknown database')) {
		$sql_error["error_msg"] = "Banco de dados não encontrado. Por favor informe o desenvolvedor!";
	} else if (strpos($msg, 'Base table or view not found')) {
		$sql_error["error_msg"] = "Tabela não encontrada. Por favor informe o desenvolvedor!";
	} else {
		$sql_error["error_msg"] = "Algo saiu errado, Por favor informe o desenvolvedor";
	}
	$sql_error["original_msg"] = $msg;
	echo json_encode($sql_error);
}

function feedback($msg)
{
	$error["error_type"] = "Aviso";
	$error["error_msg"] = $msg;
	echo json_encode($error, JSON_PRETTY_PRINT);
}

function mask($val, $mask)
{
	$maskared = '';
	$k = 0;
	for ($i = 0; $i <= strlen($mask) - 1; $i++) {
		if ($mask[$i] == '#') {
			if (isset($val[$k]))
				$maskared .= $val[$k++];
		} else {
			if (isset($mask[$i]))
				$maskared .= $mask[$i];
		}
	}
	return $maskared;
}


function dump_xml($xml)
{
	echo '<pre lang="xml" >' . htmlspecialchars($xml, ENT_QUOTES) . '</pre>';
}

function debug_xml($xml)
{
	dump_xml($xml);
	exit(0);
}

function filler($type, $start, $end, $var = null)
{
	$lenght = ($end - $start) + 1;
	$var = str_pad($var, $lenght, $type, STR_PAD_LEFT);
	return substr($var, -$lenght);
}

function filler_on_right($type, $start, $end, $var = null)
{
	$lenght = ($end - $start) + 1;
	$var = str_pad($var, $lenght, $type, STR_PAD_RIGHT);
	return substr($var, 0, $lenght);
}

function ConvertDateToBank($date)
{
	if (is_null($date)) {
		echo "";
	} else {
		$date = new DateTime($date);
		return $date->format("dmY");
	}
}

function bank_img($bank_id)
{
	switch ($bank_id) {
		case '001':
			$img_bank = 'banco_brasil.png';
			break;
		case '104':
			$img_bank = 'caixa.png';
			break;
		case '033':
			$img_bank = 'santander.png';
			break;
		case '237':
			$img_bank = 'bradesco.png';
			break;
		case '037':
			$img_bank = 'banpara.png';
			break;
		default:
			$img_bank = '';
			break;
	}
	return $img_bank;
}
function bank_name($bank_id)
{
	switch ($bank_id) {
		case '001':
			$bank_name = 'Banco do Brasil';
			break;
		case '104':
			$bank_name = 'Caixa Economica Federal';
			break;
		case '033':
			$bank_name = 'Santander';
			break;
		case '234':
			$bank_name = 'Bradesco';
			break;
		case '037':
			$bank_name = 'Banco do Estado do Pará S.A';
			break;
		case '237':
			$bank_name = 'Banco Bradesco S.A.';
			break;
		default:
			$bank_name = '';
			break;
	}
	return $bank_name;
}
// function validateSearchField($field_var){
//     if (preg_match('/^[a-z0-9_]*$/i', $field_var)){
// 		return $field_var;
// 	} else {
// 		exit(msg("Danger","Tipo de pesquisa inválido"));
// 	}
// }
function validateSearchField($field_var)
{
	try {
		if (preg_match('/^[.,a-z0-9_]*$/i', $field_var)) {
			return $field_var;
		} else {
			throw new Exception("Houve um erro ao tentar executar a solicitação");
		}
	} catch (Exception $ex) {
		msg("Danger", $ex->getMessage());
		return false;
	}
}
function validateSearchFields($fields_var)
{
	foreach ($fields_var as $field_var) {
		validateSearchField($field_var);
	}
	return true;
}
function checkIP($ip)
{

	$nIP = ip2long($ip);

	$arLocal = [
		[ip2long('127.0.0.0'),   24],
		[ip2long('10.0.0.0'),    24],
		[ip2long('172.16.0.0'),  20],
		[ip2long('192.168.0.0'), 16],
		[ip2long('169.254.0.0'), 16],
	];

	foreach ($arLocal as $arP) {

		$maskLo = ~((1 << $arP[1]) - 1);  // CREATE BIT MASK FROM NUMBER

		if (($nIP & $maskLo) === $arP[0]) // BITWISE-AND, THEN COMPARE
			return 'REDE LOCAL';
	}

	return $ip;
}


function removeIndex($arraydados)
{
	foreach (array_keys($arraydados) as $key) {
		if (is_numeric($key)) {
			unset($arraydados[$key]);
		} else if (intval($key)) {;
			unset($arraydados[$key]);
		}
	}
	return $arraydados;
}


function logAction($module, $new_data, $log_action_module_id)
{

	$data = new LogAction();
	$data->setLogActionId(null);
	$data->setLogActionModule($module);
	$data->setLogActionUser($_SESSION['usuario_nome']);
	$data->setLogActionNewData($new_data);
	$data->setLogActionCreatedAt(date('Y-m-d H:i:s'));
	$data->setLogActionIp(checkIP($_SERVER['REMOTE_ADDR']));
	$data->setLogActionLat($_SESSION['usuario_latitude']);
	$data->setLogActionLon($_SESSION['usuario_longitude']);
	$data->setLogActionAccuracy($_SESSION['usuario_accuracy']);
	$data->setLogActionModuleId($log_action_module_id);
	$data->insert();
}

$anos_disponiveis = array(
	2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026, 2027
);

$list_of_months = array(
	array(
		"month_number" => '01',
		"month_name" => 'Janeiro'
	),
	array(
		"month_number" => '02',
		"month_name" => 'Fevereiro'
	),
	array(
		"month_number" => '03',
		"month_name" => 'Março'
	),
	array(
		"month_number" => '04',
		"month_name" => 'Abril'
	),
	array(
		"month_number" => '05',
		"month_name" => 'Maio'
	),
	array(
		"month_number" => '06',
		"month_name" => 'Junho'
	),
	array(
		"month_number" => '07',
		"month_name" => 'Julho'
	),
	array(
		"month_number" => '08',
		"month_name" => 'Agosto'
	),
	array(
		"month_number" => '09',
		"month_name" => 'Setembro'
	),
	array(
		"month_number" => '10',
		"month_name" => 'Outubro'
	),
	array(
		"month_number" => '11',
		"month_name" => 'Novembro'
	),
	array(
		"month_number" => '12',
		"month_name" => 'Dezembro'
	)
);
function validarPost($post, $mensagem)
{
	$valor = $_POST[$post] ?? null;
	if (is_null($valor)) {
		throw new Exception($mensagem);
	}
	return $valor;
}
