<?php
error_reporting(1);
ini_set('memory_limit', '256M');
ini_set('error_reporting', E_ALL);
ini_set('max_execution_time', 1000000000000000);
// ini_set('memory_limit', 0);

header('Content-Security-Policy: upgrade-insecure-requests');
$date_expire_cookie = new DateTime();
$date_expire_cookie->setTimezone(new \DateTimeZone('GMT-3'));
$date_cookie = $date_expire_cookie->format(DateTimeInterface::COOKIE);
@session_start();

function getUrlSite()
{
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	$actual_link = explode("//", $actual_link);
	$protocol = $actual_link[0];
	$actual_link = explode("/", $actual_link[1]);
	$url_site = $protocol . '//' . $actual_link[0] . dirname($_SERVER['PHP_SELF']);
	$url_site = explode('/modulos', $url_site);
	$url_site =  $url_site[0];
	$url_site = str_replace('\\', '', $url_site);
	return $url_site . '/';
}

function getRelativePath($file)
{
	$rel_path_string = str_replace("\\/", "/", substr($file, strlen($_SERVER['DOCUMENT_ROOT'] . dirname($_SERVER['PHP_SELF']) . '/')));
	$rel_path_string = str_replace("\\", "/", $rel_path_string);
	$rel_path_contructor = explode('/', $rel_path_string);
	$rel_path = '';
	$i = 0;
	foreach ($rel_path_contructor as $key) {
		if (++$i != count($rel_path_contructor)) {
			$rel_path .= '../';
		}
	}
	return $rel_path;
}
function getAbsolutePath($file)
{
	$folder = getUrlSite() . str_replace("\\", "/", substr($file, strlen($_SERVER['DOCUMENT_ROOT'] . dirname($_SERVER['PHP_SELF'])))) . '/';
	$folder = str_replace('//modulos', '/modulos', $folder);
	$folder = str_replace('//', '/', $folder);
	$folder = str_replace('https:/', 'https://', $folder);
	$folder = str_replace('http:/', 'http://', $folder);
	$last_char = substr($folder, -1);
	if ($last_char == '/') {
		$folder = substr($folder, 0, -1);
	}
	$folder = $folder . '/';
	return $folder;
}
define('ROOT', __DIR__);
define('DS', DIRECTORY_SEPARATOR);
define('__ABSOULTE_PATH__', getAbsolutePath(dirname(__FILE__)));
define('__IMAGES__', __ABSOULTE_PATH__ . 'images/');
define('__CSS__', __ABSOULTE_PATH__ . 'assets/css/');
define('__JAVASCRIPT__', __ABSOULTE_PATH__ . 'assets/js/');
define('__PHP__', __ABSOULTE_PATH__ . 'assets/php/');
define('__FILES__', __ABSOULTE_PATH__ . 'files/');
define('__AJAX_OPTIONS__', __ABSOULTE_PATH__ . 'ajax_options/');
define('__URLSITE__', getUrlSite());
define('__CDN__', __URLSITE__);
$url_site = __URLSITE__;


function loadClasses($className)
{
	$className = strtolower($className);
	$paths = scandir(__DIR__ . '/classes/');
	$include = '';
	foreach ($paths as $class_dir) {
		if (file_exists(ROOT . DS . 'classes/' . $class_dir . DS . $className . '.php')) {
			$include = ROOT . DS . 'classes/' . $class_dir  . DS . $className . '.php';
		}
	}
	if ($include != '') {
		require_once($include);
	} else {
		echo Funcao::msg("Error", "Classe '$className' não encontrada. Verifique o nome do arquivo e tente novamente");
		exit();
	}
}
spl_autoload_register("loadClasses");
// debugador
function debug_code($data,  $exit = true)
{
	echo "<pre>";
	print_r($data);
	echo "</pre>";
	if ($exit) {
		exit(0);
	}
}
// Bloco de consulta datatables
$draw = $_POST["draw"] ?? null;
$row = $_POST["start"] ?? null;
$rowperpage = $_POST["length"] ?? null;
$columnIndex = $_POST["order"][0]["column"] ?? null;
$columnName = $_POST["columns"][$columnIndex]["data"] ?? null;
$columnSortOrder = $_POST["order"][0]["dir"] ?? null;
$searchValue = $_POST["search"]["value"] ?? null;
$limite = "$row,$rowperpage";
$colunas = array();
// Pega todas as colunas
if (isset($_POST["columns"])) {
	foreach ($_POST["columns"] as $coluna) {
		if ($coluna["data"] != "") {
			$colunas[] = $coluna["data"];
		}
	}
	unset($colunas[count($colunas) - 1]);
}
// Bloco de consulta datatables

// URL Amigável
if (isset($_GET["url"])) {
	$url = explode("/", $_GET["url"]);
	$url_nav = '';
	$last_key = end($url);
	if (is_numeric($last_key)) {
		$url_id = $last_key;
	}
	foreach ($url as $key_url => $data_url) {
		if (strlen($last_key) == 32 || is_numeric($last_key)) {
			if ($data_url != $last_key) {
				$url_nav = $url_nav . "/" . $data_url;
			}
		} else {
			$url_nav = $url_nav . "/" . $data_url;
		}
	}
} else {
	$url = array();
	$url_nav = '';
}

$app_version = '1.2.1';

//END PARAMS
require_once('vendor/autoload.php');

// CHAMA A PAGINA PARA LOGIN E SENHA NO SISTEMA
if (
	strpos($_SERVER['REQUEST_URI'], "login.php") === false
) {
	require_once "assets/php/secure.php";
}

require_once "assets/php/customFunctions.php";
//FirePHP
if (Configuracao::$log_sql) {
	@ob_start();
	Funcao::msg('Alerta', 'Fire PHP está ativado, output buffer não funciona com esta opção ativada');
}
