<?php
class Assinador extends Database{

    public static function assinarXML($xml,$certificado,$senha){
        $xmlns = 'http://www.w3.org/2000/09/xmldsig#';
        $canonicalizationMethod = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
        $signatureMethod = 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256';
        $digestAlgorithm = 'sha256';
        $digestMethod = 'http://www.w3.org/2001/04/xmlenc#sha256';
        $transformMethod = 'http://www.w3.org/2000/09/xmldsig#enveloped-signature';
        $algorithm = OPENSSL_ALGO_SHA256;

        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = true;
        $dom->formatOutput = false;
        $dom->loadXML($xml);

        $canonicalData = $dom->C14N(true, false);
        $hash = openssl_digest($canonicalData, $digestAlgorithm, true);
        $digestValue = base64_encode($hash);

        $root = $dom->getElementsByTagName('eSocial')->item(0);
        $signatureNode = $dom->createElementNS($xmlns, 'Signature');
        $root->appendChild($signatureNode);
        $signedInfoNode = $dom->createElement('SignedInfo');
        $signatureNode->appendChild($signedInfoNode);
        $canonicalNode = $dom->createElement('CanonicalizationMethod');
        $signedInfoNode->appendChild($canonicalNode);
        $canonicalNode->setAttribute('Algorithm', $canonicalizationMethod);
        $signatureMethodNode = $dom->createElement('SignatureMethod');
        $signedInfoNode->appendChild($signatureMethodNode);
        $signatureMethodNode->setAttribute('Algorithm', $signatureMethod);
        $referenceNode = $dom->createElement('Reference');
        $signedInfoNode->appendChild($referenceNode);
        $referenceNode->setAttribute('URI', '');
        $transformsNode = $dom->createElement('Transforms');
        $referenceNode->appendChild($transformsNode);
        $transfNode1 = $dom->createElement('Transform');
        $transformsNode->appendChild($transfNode1);
        $transfNode1->setAttribute('Algorithm', $transformMethod);
        $transfNode2 = $dom->createElement('Transform');
        $transformsNode->appendChild($transfNode2);
        $transfNode2->setAttribute('Algorithm', $canonicalizationMethod);
        $digestMethodNode = $dom->createElement('DigestMethod');
        $referenceNode->appendChild($digestMethodNode);
        $digestMethodNode->setAttribute('Algorithm', $digestMethod);
        $digestValueNode = $dom->createElement('DigestValue', $digestValue);
        $referenceNode->appendChild($digestValueNode);

        $c14n = $signedInfoNode->C14N(true, false);

        if (!file_exists($certificado)) {
            throw new Exception("Certificado não encontrado!");
        }
        $certificate = file_get_contents($certificado);
        if (!$certificate) {
            throw new Exception("Erro nas permissões do certificado!");
        }
        
        $privateKey = openssl_pkey_get_private($certificate, $senha);
        if (!$privateKey) {
            throw new Exception('Certificado e/ou senha inválidos!');
        }
        $signature = '';
        if (!openssl_sign($c14n, $signature, $privateKey, $algorithm)) {
            throw new Exception('Erro ao criar assinatura!');
        }
        $signatureValue = base64_encode($signature);

        $signatureValueNode = $dom->createElement('SignatureValue', $signatureValue);
        $signatureNode->appendChild($signatureValueNode);
        $keyInfoNode = $dom->createElement('KeyInfo');
        $signatureNode->appendChild($keyInfoNode);
        $x509DataNode = $dom->createElement('X509Data');
        $keyInfoNode->appendChild($x509DataNode);

        $regex = '/-----BEGIN CERTIFICATE-----\n(.*?)\n-----END CERTIFICATE-----/ms';
        preg_match_all($regex, $certificate, $resultado, PREG_SET_ORDER, 0);
        $x509certificate = $resultado[0][1];
        $x509certificate = preg_replace('/[\n\r]/', '', $x509certificate);

        $x509CertificateNode = $dom->createElement('X509Certificate', $x509certificate);
        $x509DataNode->appendChild($x509CertificateNode);

        return $dom->saveXML($root);

    }
}