<?php
class Colare extends Database
{

    private static $ambiente = 'produção';

    private $url_arquivo = "/recepcao/arquivo/upload";
    private $url_retificacao = "/recepcao/ATOSDEPESSOAL/PES_RETIFICAHOM";
    private $url_legislacao = "/recepcao/ATOSDEPESSOAL/PES_LEGISLACAO";
    private $url_cargo = "/recepcao/ATOSDEPESSOAL/PES_CARGOS";
    private $url_verba = "/recepcao/ATOSDEPESSOAL/PES_VERBAS";
    private $url_pessoa = "/recepcao/ATOSDEPESSOAL/PES_CADASTRO";
    private $url_admissao = "/recepcao/ATOSDEPESSOAL/PES_ADMISSAO";
    private $url_lotacao = "/recepcao/ATOSDEPESSOAL/PES_VF_LOTACAO";
    private $url_disposicao = "/recepcao/ATOSDEPESSOAL/PES_VF_DISP";
    private $url_licenca = "/recepcao/ATOSDEPESSOAL/PES_VF_LICENCA";
    private $url_desligamento = "/recepcao/ATOSDEPESSOAL/PES_VF_DESL_INT";
    private $url_alteracao_cargo = "/recepcao/ATOSDEPESSOAL/PES_VF_ALTCARGO";
    private $url_aposentadoria = "/recepcao/ATOSDEPESSOAL/PES_APOSENT";
    private $url_pensao = "/recepcao/ATOSDEPESSOAL/PES_PENSIONIST";
    private $url_concessao = "/recepcao/ATOSDEPESSOAL/PES_CONCESSAO";
    private $url_folha = "/recepcao/FOLHAPAGAMENTO/PES_FOLHAPAG";



    public function __construct()
    {
        global $url_site;
        if (!isset($_SESSION["colare_senha"]) || !isset($_SESSION["colare_representacao"])) {
            echo '<script>requisicaoPOST({"url": "' . $url_site . '/modulos/integracoes/colare/colare/password.php",
                            "campos": {},
                            "conteudo": "#mainModalContent",
                            "callback": mainModalLoadingEnd,
                            "callbackparams": "small"
                          });</script>';
            throw new Exception("Informe a senha do certificado cadastrado.");
        }
        if (!isset($_SESSION["colare_token"])) {
            $this->getToken();
        }
    }

    private static function getCertificado()
    {
        $user = new Usuario();
        $user->setUsuarioId($_SESSION["usuario_id"]);
        $dados = $user->getCertificadoColare();
        if (!isset($dados["usuario_colare_certificado"])) {
            throw new Exception("O usuário não possui um certificado cadastrado!");
        }
        $tmpCertificate = sys_get_temp_dir() . "/" . date("dmyhis") . rand(0, 999) . ".pem";
        file_put_contents($tmpCertificate, $dados["usuario_colare_certificado"]);
        return $tmpCertificate;
    }

    public static function getRepresentacoes($senha)
    {
        $senha = trim($senha);
        if (Colare::$ambiente == "produção") {
            $url_representacoes = "https://wwws.tcm.go.gov.br/passaporte/api/auth/representacoes";
        } else {
            $url_representacoes = "https://testes.tcm.go.gov.br:8443/passaporte/api/auth/representacoes";
        }
        $curl = new CURL($url_representacoes);
        $curl->definirCabecalho();
        $curl->informarCertificado(Colare::getCertificado(), $senha);
        $retorno = $curl->executar();
        if (isset($retorno->representacoes)) {
            //debug_code($retorno->representacoes);
            return $retorno->representacoes;
        } else {
            throw new Exception("Erro ao obter representações. <br> Verifique a senha e tente novamente!");
        }
    }

    private function getToken()
    {
        $curl = new CURL($this->getTokenUrl() . $_SESSION["colare_representacao"]);
        $curl->definirCabecalho();
        $curl->informarCertificado(Colare::getCertificado(), $_SESSION["colare_senha"]);
        $retorno = $curl->executar();
        if (isset($retorno->token->valor)) {
            $_SESSION["colare_token"] = $retorno->token->valor;
        } else {
            throw new Exception("Erro ao obter token!");
        }
    }

    private function validarRetorno($retorno)
    {
        if (is_array($retorno)) {
            foreach ($retorno as $resultado) {
                if (isset($resultado->message)) {
                    $this->validarToken($resultado->message);
                    throw new Exception($resultado->message);
                }
            }
        } else {
            if (isset($retorno->mensagem)) {
                throw new Exception($retorno->mensagem);
            }
            if (isset($retorno->message)) {
                $this->validarToken($retorno->message);
                throw new Exception($retorno->message);
            }
            if (isset($retorno->mensagens)) {
                if (count($retorno->mensagens->erros) > 0) {
                    $erros = $this->getMensagens($retorno->mensagens->erros);
                    throw new Exception($erros);
                }
                if (count($retorno->mensagens->advertencias) > 0) {
                    $advertencias = $this->getMensagens($retorno->mensagens->advertencias);
                    msg("Alert", $advertencias);
                }
                if (count($retorno->mensagens->informacoes) > 0) {
                    $informacoes = $this->getMensagens($retorno->mensagens->informacoes);
                    msg("Info", $informacoes);
                }
            }
        }
    }

    private function getMensagens($vetor)
    {
        $mensagens = "";
        foreach ($vetor as $mensagem) {
            $mensagens .= $mensagem->mensagem . "<hr style=\"margin:8px;color:#fff;\">";
        }
        return substr($mensagens, 0, -35);
    }

    private function validarToken($mensagem)
    {
        if (str_contains($mensagem, 'Token')) {
            $this->getToken();
            throw new Exception("Token inválido, gerando novo token...");
        }
    }

    public function gerarLog($id, $tipo, $pedido_retificacao, $json)
    {
        return $this->executeDb(
            "INSERT INTO log_colare
                VALUES(0,
                :log_colare_user,
                :log_colare_system_id,
                :log_colare_type,
                :log_colare_rectification_request,
                :log_colare_receipt,
                :log_colare_json,
                now()
            )",
            array(
                "log_colare_user" => $_SESSION["usuario_id"],
                "log_colare_system_id" => $id,
                "log_colare_type" => $tipo,
                "log_colare_rectification_request" => $pedido_retificacao,
                "log_colare_receipt" => $json->arquivo->recibo,
                "log_colare_json" => json_encode($json)
            )
        );
    }

    // Quando conseguirem assinar documentos que o tribunal aceite
    // public function homologateLaw($id,$recibo){
    //     $arquivo = file_get_contents("https://testes.tcm.go.gov.br/envio-manual/api/envio/pdf/homologacao/$recibo");
    //     file_put_contents("algum_lugar_temporário",$arquivo);
    //     $arquivo_assinado = assinar_arquivo($arquivo); // obviamente não existe essa função
    //     $curl = new CURL($this->getRequestUrl($this->url_legislacao)."/$id/homologar","put");
    //     $curl->definirCabecalho(null,true);
    //     if(is_file($arquivo_assinado)){
    //         $caminho = curl_file_create($arquivo_assinado, 'application/pdf', 'arquivo');
    //         $curl->definirConteudo(array('arquivo' => $caminho));
    //         $retorno = $curl->executar();
    //         $this->validarRetorno($retorno);
    //         return $retorno->arquivo;
    //     }else{
    //         throw new Exception("Informe o desenvolvedor: arquivo não encontrado!");
    //     }
    // }

    private function getUrl($url)
    {
        if (Colare::$ambiente == "produção") {
            $url = "https://virtual.tcm.go.gov.br" . $url;
        } else {
            $url = "https://testes.tcm.go.gov.br" . $url;
        }
        return $url;
    }

    private function getTokenUrl()
    {
        if (Colare::$ambiente == "produção") {
            return "https://wwws.tcm.go.gov.br/passaporte/api/auth/certificado?representacao=";
        } else {
            return "https://testes.tcm.go.gov.br:8443/passaporte/api/auth/certificado?representacao=";
        }
    }

    private function getRequestUrl($url, $mes = null, $ano = null)
    {
        $url = $this->getUrl($url);
        if (is_null($mes) && is_null($ano)) {
            return $url . "/" . date("m") . "/" . date("Y");
        } else {
            return $url . "/$mes/$ano";
        }
    }

    public function validate($url, $conteudo, $validar = false)
    {
        $curl = new CURL($url, "post");
        $curl->definirCabecalho();
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        if ($validar) {
            $this->validarRetorno($retorno);
        }
        return $retorno;
    }

    public function file($blob)
    {
        $curl = new CURL($this->getUrl($this->url_arquivo), "post");
        $curl->definirCabecalho($_SESSION["colare_token"], true);
        $tmpfile = tmpfile();
        fwrite($tmpfile, substr($blob, 0, -1));
        $arquivo = stream_get_meta_data($tmpfile)['uri'];
        if (is_file($arquivo)) {
            $caminho = curl_file_create($arquivo, 'application/pdf', 'arquivo');
            $curl->definirConteudo(array('arquivo' => $caminho));
            $retorno = $curl->executar();
            $this->validarRetorno($retorno);
            return $retorno->arquivo;
        } else {
            throw new Exception("Informe o desenvolvedor: arquivo não encontrado!");
        }
    }

    public function rectity($conteudo, $mes, $ano)
    {
        $curl = new CURL($this->getRequestUrl($this->url_retificacao, $mes, $ano), "post");
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function lei($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_legislacao) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_legislacao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function cargo($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_cargo) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_cargo), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function verba($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_verba, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_verba), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function pessoa($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_pessoa, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_pessoa), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function admissao($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_admissao, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_admissao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function lotacao($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_lotacao, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_lotacao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function disposicao($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_disposicao) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_disposicao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function licenca($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_licenca) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_licenca), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function desligamento($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_desligamento) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_desligamento), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function alteracaoCargo($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_alteracao_cargo) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_alteracao_cargo), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function aposentadoria($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_aposentadoria, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_aposentadoria), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function pensao($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_pensao, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_pensao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function concessao($conteudo, $action, $id = null,  $mes = null, $ano = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_concessao) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_concessao), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }

    public function folha($mes, $ano, $conteudo, $action, $id = null)
    {
        if ($action == "rectity") {
            $curl = new CURL($this->getRequestUrl($this->url_folha, $mes, $ano) . "/$id", "put");
        } else {
            $curl = new CURL($this->getRequestUrl($this->url_folha, $mes, $ano), "post");
        }
        $curl->definirCabecalho($_SESSION["colare_token"]);
        $curl->definirConteudo($conteudo);
        $retorno = $curl->executar();
        $this->validarRetorno($retorno);
        return $retorno;
    }
}
