<?php
class CURL
{

    private $curl;
    private $debug = false;
    private $tmpCertificate;

    public function __construct($url, $tipo = "get")
    {
        // Inicializando sessão cURL
        $this->curl = curl_init();
        // Definindo destino
        curl_setopt($this->curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($this->curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($this->curl, CURLOPT_URL, $url);
        // Tipo da requisição
        if ($tipo == "post") {
            curl_setopt($this->curl, CURLOPT_CUSTOMREQUEST, "POST");
        } else if ($tipo == "put") {
            curl_setopt($this->curl, CURLOPT_CUSTOMREQUEST, "PUT");
        }
        // Retornar String em vez de imprimir
        curl_setopt($this->curl, CURLOPT_RETURNTRANSFER, true);
        // Ativar captura de erros
        if ($this->debug) {
            curl_setopt($this->curl, CURLOPT_FAILONERROR, true);
            curl_setopt($this->curl, CURLINFO_HEADER_OUT, true);
        }
    }

    public function definirCabecalho($token = null, $arquivo = false)
    {
        $headers = array('Cache-Control: no-cache');
        if (!is_null($token)) {
            $headers[] = 'Authorization: ' . $token;
        }
        if ($arquivo) {
            $headers[] = 'Content-Type: multipart/form-data';
        } else {
            $headers[] = 'Content-Type: application/json';
        }
        curl_setopt($this->curl, CURLOPT_HTTPHEADER, $headers);
    }

    public function informarCertificado($certificado, $senha)
    {
        curl_setopt($this->curl, CURLOPT_SSLCERT, $certificado);
        curl_setopt($this->curl, CURLOPT_SSLCERTPASSWD, $senha);
        curl_setopt($this->curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($this->curl, CURLOPT_SSL_VERIFYHOST, false);
    }

    public function definirConteudo($conteudo)
    {
        curl_setopt($this->curl, CURLOPT_POSTFIELDS, $conteudo);
    }

    public function executar()
    {
        // Resultado
        $retorno = json_decode(curl_exec($this->curl));
        // Removendo certificado
        if ($this->tmpCertificate != "") {
            unlink($this->tmpCertificate);
        }
        // DEBUG
        if ($this->debug) {
            $info = curl_getinfo($this->curl);
            dump_code($info);
            // Capturando erro
            if (curl_errno($this->curl)) {
                throw new Exception(curl_error($this->curl));
            }
        }
        // Fechando conexão
        curl_close($this->curl);
        // Tudo OK
        return $retorno;
    }
}
