<?php
class Documentos extends Configuracao
{
	private static $conexao = null;

	public function __construct()
	{
		$this->conectar();
	}

	private function conectar()
	{
		try {
			if (is_null(Documentos::$conexao)) {
				$db = $this->banco;
				$mongo = new MongoDB\Client("mongodb://{$this->usuario}:{$this->senha}@{$this->servidor}");
				$mongo->listDatabases();
				Documentos::$conexao = $mongo->$db->selectGridFSBucket();
			}
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function enviar($identificador, $metadata, $arquivo)
	{
		try {
			$stream = fopen($arquivo, 'rb');
			$fileId = Documentos::$conexao->uploadFromStream($identificador, $stream, [
				'metadata' => $metadata
			]);
			return $fileId;
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function excluirTudo($tabela, $pk)
	{
		try {
			$cursor = Documentos::$conexao->find(['metadata.tabela' => $tabela, 'metadata.pk' => $pk]);
			foreach ($cursor as $documento) {
				Documentos::$conexao->delete($documento['_id']);
			}
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function excluir($id)
	{
		try {
			$fileId = new MongoDB\BSON\ObjectId($id);
			return Documentos::$conexao->delete($fileId);
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function getArquivo($id)
	{
		try {
			$fileId = new MongoDB\BSON\ObjectId($id);
			$stream = Documentos::$conexao->openDownloadStream($fileId);
			return stream_get_contents($stream);
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function getArquivoIdentificador($identificador)
	{
		try {
			$stream = Documentos::$conexao->openDownloadStreamByName($identificador);
			return stream_get_contents($stream);
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}

	public function getFileId($identificador)
	{
		try {
			$stream = Documentos::$conexao->openDownloadStreamByName($identificador);
			return Documentos::$conexao->getFileIdForStream($stream);
		} catch (Exception $erro) {
			throw new Exception($erro->getMessage());
		}
	}
}
