<?php
class ESocial extends Database
{
    private $urlEnvio = "https://webservices.producaorestrita.esocial.gov.br/servicos/empregador/enviarloteeventos/WsEnviarLoteEventos.svc?wsdl";
    private $urlConsulta = "https://webservices.producaorestrita.esocial.gov.br/servicos/empregador/consultarloteeventos/WsConsultarLoteEventos.svc?wsdl";

    private $tipoEmpregador;
    private $inscricaoEmpregador;
    private $naturezaJuridicaEmpregador;
    private $inscricaoTransmissor;
    private $tipoTransmissor;

    private $tipoAmbiente;
    private $processoEmissao;
    private $versaoEmissor;

    private $soapClient;
    private $certificado;
    private $senhaCertificado;

    public function __construct($tipo="envio")
    {
        global $url_site;
        if (!isset($_SESSION["esocial_senha"])) {
            echo '<script>requisicaoPOST({"url": "' . $url_site . 'modulos/integracoes/esocial/esocial/password.php",
                            "campos": {},
                            "conteudo": "#mainModalContent",
                            "callback": mainModalLoadingEnd,
                            "callbackparams": "small"
                          });</script>';
            throw new Exception("Informe a senha do certificado cadastrado.");
        }
        $this->conectar($tipo);
        $this->buscarDadosEmpregador();
        $this->buscarDadosTransmissor();
        $this->preencherInformacoesEvento();
    }

    private function conectar($tipo){
        $context = stream_context_create([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ]);
        $this->certificado = $this->getCertificado();
        $this->senhaCertificado = $_SESSION["esocial_senha"];
        $parametros = array(
            'local_cert' => $this->certificado,
            'passphrase' => $this->senhaCertificado,
            'trace' => 1,
            'stream_context' => $context
        );
        $url = ($tipo=="envio") ?$this->urlEnvio : $this->urlConsulta;
        $this->soapClient = new SoapClient($url, $parametros);
    }

    public function consultarLote($protocoloEnvio){
        $xml = '<ns1:ConsultarLoteEventos>
                    <eSocial xmlns="http://www.esocial.gov.br/schema/lote/eventos/envio/consulta/retornoProcessamento/v1_0_0">
                        <consultaLoteEventos>
                            <protocoloEnvio>'.$protocoloEnvio.'</protocoloEnvio>
                        </consultaLoteEventos>
                    </eSocial>
                </ns1:ConsultarLoteEventos>';
        $soapVar = new SoapVar($xml, XSD_ANYXML);
        $resultado_xml = $this->soapClient->ConsultarLoteEventos($soapVar);
        return simplexml_load_string($resultado_xml->ConsultarLoteEventosResult->any);
    }

    public function enviar($xmlSoap){
        $soapVar = new SoapVar($xmlSoap, XSD_ANYXML);
        $resultado_xml = $this->soapClient->EnviarLoteEventos($soapVar);
        return simplexml_load_string($resultado_xml->EnviarLoteEventosResult->any);
    }

    private function buscarDadosTransmissor(){
        $this->inscricaoTransmissor = $_SESSION["usuario_esocial_inscricao"] ?? null;
        if(is_null($this->inscricaoTransmissor)){
            throw new Exception("Inscrição do transmissor inválida!");
        }
        $this->tipoTransmissor = (strlen($this->inscricaoTransmissor)>11) ? "1" : "2"; // 1 = CNPJ, 2 = CPF
    }

    public function preencherInformacoesEvento(){
        $this->tipoAmbiente = "2"; // 1 - Produção; 2 - Produção restrita; 7 - Validação (uso interno); 8 - Teste (uso interno); 9 - Desenvolvimento (uso interno)
        $this->processoEmissao = "1"; // 1 - Aplicativo do empregador; 2 - Aplicativo governamental - Simplificado Pessoa Física; 3 - Aplicativo governamental - Web Geral; 4 - Aplicativo governamental - Simplificado Pessoa Jurídica; 9 - Aplicativo governamental - Integração com a Junta Comercial; 22 - Aplicativo governamental para dispositivos móveis - Empregador Doméstico
        $this->versaoEmissor = "1.0"; // Versão do aplicativo emissor do evento
    }

    private function buscarDadosEmpregador(){
        $entidade = new Entidade();
        $entidade->pk($_SESSION["usuario_entidade_id"]);
        if($entidade->consultar(6)==false){
            throw new Exception("Empregador não encontrado!");
        }else{
            $this->tipoEmpregador = "1"; // 1 = CNPJ, 2 = CPF
            $this->inscricaoEmpregador = $entidade->entidade_cnpj;
            $this->naturezaJuridicaEmpregador = $entidade->entidade_natureza_juridica_codigo;
            $this->verificarDadosEmpregador();
        }
    }

    private function verificarDadosEmpregador(){
        if(!($this->tipoEmpregador=="1" || $this->tipoEmpregador=="2")){
            throw new Exception("Tipo do empregador inválido!");
        }
        if(empty($this->inscricaoEmpregador)){
            throw new Exception("Inscrição do empregador inválida!");
        }
        if(empty($this->naturezaJuridicaEmpregador)){
            throw new Exception("Natureza juridica do empregador inválida!");
        }
    }

    private function getCertificado()
    {
        $user = new Usuario();
        $user->pk($_SESSION["usuario_id"]);
        $dados = $user->getCertificadoESocial();
        if (!isset($dados["usuario_esocial_certificado"])) {
            throw new Exception("O usuário não possui um certificado cadastrado!");
        }
        $tmpCertificate = sys_get_temp_dir() . "/" . date("dmyhis") . rand(0, 999) . ".pem";
        file_put_contents($tmpCertificate, $dados["usuario_esocial_certificado"]);
        return $tmpCertificate;
    }

    public function assinarEvento($xmlEvento){
        return Assinador::assinarXML($xmlEvento, $this->certificado, $this->senhaCertificado);
    }

    public function gerarIdEvento(){
        $this->verificarDadosEmpregador();
        if ($this->tipoEmpregador == 1) {
            if ($this->isInscricaoCompleta()) {
                $idEvento = "ID1" . $this->getInscricaoEmpregador() . $this->fimIdEvento();
            } else {
                $idEvento = "ID1" . $this->getInscricaoEmpregador() . "000000" . $this->fimIdEvento();
            }
        } else {
            $idEvento = "ID2" . $this->getInscricaoEmpregador() . "000" . $this->fimIdEvento();
        }
        return $idEvento;
    }

    private function fimIdEvento(){
        return date("YmdHis") . rand(10000, 99999);
    }

    private function getCabecalhoEvento($indicativoRetificacao=null,$recibo=null,$indicativoApuracao=null,$periodoApuracao=null){
        $xml = '<ideEvento>';
        if(!is_null($indicativoRetificacao)){
            $xml .=     '<indRetif>' . $indicativoRetificacao . '</indRetif>';
            if($indicativoRetificacao=="2"){
                if(is_null($recibo)){
                    throw new Exception("Número do recibo não informado!");
                }
                $xml .=     '<nrRecibo>' . $recibo . '</nrRecibo>';
            }
        }
        if(!is_null($indicativoApuracao)){
            $xml .=     '<indApuracao>' . $indicativoApuracao . '</indApuracao>';
        }
        if(!is_null($periodoApuracao)){
            $xml .=     '<perApur>' . $periodoApuracao . '</perApur>';
        }
        $xml .=     '<tpAmb>' . $this->tipoAmbiente . '</tpAmb>
                    <procEmi>' . $this->processoEmissao . '</procEmi>
                    <verProc>' . $this->versaoEmissor . '</verProc>
                </ideEvento>
                <ideEmpregador>
                    <tpInsc>' . $this->tipoEmpregador . '</tpInsc>
                    <nrInsc>' . $this->getInscricaoEmpregador() . '</nrInsc>
                </ideEmpregador>';
        return $xml;
    }

    public function gerarXMLEvento($acao,$tipoEvento,$tipoInformacao,$xmlDados){
        $idEvento = $this->gerarIdEvento();
        $xml =          '<evento Id="'.$idEvento.'">';
        $xmlEvento =    '<eSocial xmlns="http://www.esocial.gov.br/schema/evt/'.$tipoEvento.'/v_S_01_00_00">
                            <'.$tipoEvento.' Id="' . $idEvento . '">
                            '.$this->getCabecalhoEvento().'
                            <'.$tipoInformacao.'>';
        if($acao=="Enviar"){
            $acaoXML = "inclusao";
        }else if($acao=="Alterar"){
            $acaoXML = "alteracao";
        }else if($acao=="Excluir"){
            $acaoXML = "exclusao";
        }else{
            throw new Exception("Ação inválida!");
        }
        $xmlEvento .= '<'.$acaoXML.'>'.$xmlDados.'</'.$acaoXML.'>';
        $xmlEvento .=  '</'.$tipoInformacao.'></'.$tipoEvento.'></eSocial>';
        $xml .= $this->assinarEvento($xmlEvento);
        $xml .= '</evento>';
        return $xml;
    }

    public function gerarXMLEventoUnico($acao,$tipoEvento,$xmlDados,$recibo=null,$indicativoApuracao=null,$periodoApuracao=null){
        if($acao=="Enviar"){
            $indicativoRetificacao = "1";
        }else if($acao=="Alterar"){
            $indicativoRetificacao = "2";
        }else{
            throw new Exception("Ação não permitida nesse layout!");
        }
        $idEvento = $this->gerarIdEvento();
        $xml =          '<evento Id="'.$idEvento.'">';
        $xmlEvento =    '<eSocial xmlns="http://www.esocial.gov.br/schema/evt/'.$tipoEvento.'/v_S_01_00_00">
                            <'.$tipoEvento.' Id="' . $idEvento . '">
                                '.$this->getCabecalhoEvento($indicativoRetificacao,$recibo,$indicativoApuracao,$periodoApuracao).'
                                '.$xmlDados.'
                            </'.$tipoEvento.'>
                         </eSocial>';
        $xml .= $this->assinarEvento($xmlEvento);
        $xml .= '</evento>';
        return $xml;
    }

    public function gerarXMLS3000($tipo_evento,$recibo,$cpf_trabalhador=null){
        $idEvento = $this->gerarIdEvento();
        $xml =          '<evento Id="'.$idEvento.'">';
        $xmlEvento =    '<eSocial xmlns="http://www.esocial.gov.br/schema/evt/evtExclusao/v_S_01_00_00">
                            <evtExclusao Id="' . $idEvento . '">
                                '.$this->getCabecalhoEvento(null,$recibo,null,null).'
                                <infoExclusao>
                                    <tpEvento>'.$tipo_evento.'</tpEvento>
                                    <nrRecEvt>'.$recibo.'</nrRecEvt>';
        if(!is_null($cpf_trabalhador)){
            $xmlEvento .=           '<ideTrabalhador>
                                        <cpfTrab>'.$cpf_trabalhador.'</cpfTrab>
                                     </ideTrabalhador>';
        }
        $xmlEvento .=           '</infoExclusao>
                            </evtExclusao>
                         </eSocial>';
        $xml .= $this->assinarEvento($xmlEvento);
        $xml .= '</evento>';
        return $xml;
    }

    private function isInscricaoCompleta(){
        return ($this->naturezaJuridicaEmpregador == "1015" || $this->naturezaJuridicaEmpregador == "1040" || $this->naturezaJuridicaEmpregador == "1074" || $this->naturezaJuridicaEmpregador == "1163" || $this->naturezaJuridicaEmpregador == "1341");
    }

    public function tratarRetornoEnvio($resultado,$mensagem=true){
        $ocorrencias = $resultado->retornoEnvioLoteEventos->status->ocorrencias->ocorrencia ?? null;
        if(is_null($ocorrencias)){
            if($mensagem){
                msg("Success", "{$this->getProtocoloEnvio($resultado)} enviado com sucesso!");
            }
            return true;
        }else{
            foreach($ocorrencias as $ocorrencia){
                msg("Error", $ocorrencia->descricao);
            }
            return false;
        }
    }

    public function tratarRetornoConsulta($resultado){
        $sucesso = true;
        if(isset($resultado->retornoProcessamentoLoteEventos->retornoEventos->evento[1])){
            foreach($resultado->retornoProcessamentoLoteEventos->retornoEventos->evento as $evento){
                $ocorrencias = $evento->retornoEvento->eSocial->retornoEvento->processamento->ocorrencias->ocorrencia ?? null;
                if(!$this->tratarOcorrenciasConsulta($ocorrencias,$evento)){
                    $sucesso = false;
                }
            }
        }else{
            $evento = $resultado->retornoProcessamentoLoteEventos->retornoEventos->evento;
            $ocorrencias = $resultado->retornoProcessamentoLoteEventos->status->ocorrencias->ocorrencia ?? ($evento->retornoEvento->eSocial->retornoEvento->processamento->ocorrencias->ocorrencia ?? null);
            $sucesso = $this->tratarOcorrenciasConsulta($ocorrencias,$evento);
        }
        return $sucesso;
    }

    public function getNumeroRecibo($resultado){
        return $resultado->retornoProcessamentoLoteEventos->retornoEventos->evento->retornoEvento->eSocial->retornoEvento->recibo->nrRecibo;
    }

    private function tratarOcorrenciasConsulta($ocorrencias,$evento){
        $sucesso = false;
        $identificador = "Erro";
        if(!is_null($evento)){
            $identificador = $evento->retornoEvento->eSocial->retornoEvento->recepcao->protocoloEnvioLote ?? $evento->attributes()["Id"];
        }
        if(is_null($ocorrencias)){
            $processamento = $evento->retornoEvento->eSocial->retornoEvento->processamento;
            if($processamento->cdResposta=="411"){
                msg("Error", "{$identificador} - {$processamento->descResposta}");
            }else{
                $sucesso = true;
                msg("Success", "{$identificador} - Lote processado com sucesso!");
            }
        }else{
            foreach($ocorrencias as $ocorrencia){
                if(!is_null($ocorrencia)){
                    msg("Error", "{$identificador} - {$ocorrencia->descricao}");
                }
            }
        }
        return $sucesso;
    }

    public function gerarLog($layout,$acao,$protocolo_envio,$protocolo_anterior,$quantidade_eventos,$xml){
        $lote = new ESocialLote();
        $lote->esocial_lote_layout= $layout;
        $lote->esocial_lote_acao = $acao;
        $lote->esocial_lote_data = date("Y-m-d H:i:s");
        $lote->esocial_lote_protocolo = $protocolo_envio;
        $lote->esocial_lote_protocolo_anterior = $protocolo_anterior;
        $lote->esocial_lote_quantidade_eventos = $quantidade_eventos;
        $lote->esocial_lote_status = "Em processamento";
        $dom = new DOMDocument();
        $dom->preserveWhiteSpace = false;
        $dom->formatOutput = false;
        $dom->loadXML($xml);
        $root = $dom->getElementsByTagName('eSocial')->item(0);
        $lote->esocial_lote_xml_envio = $dom->saveXML($root);
        $lote->cadastrar();
    }

    public static function tratarExcecao($ex){
        if(!strpos($ex->getMessage(),"Could")===false){
            msg("Error","Certificado e/ou senha do certificado inválida!");
            unset($_SESSION["esocial_senha"]);
        }else{
            msg("Error",$ex->getMessage());
        }
    }

    public function getXMLCabecalho($grupo="1"){
        return '<eSocial xmlns="http://www.esocial.gov.br/schema/lote/eventos/envio/v1_1_1">
                    <envioLoteEventos grupo="'.$grupo.'">
                        <ideEmpregador>
                            <tpInsc>' . $this->tipoEmpregador . '</tpInsc>
                            <nrInsc>' . $this->getInscricaoEmpregador() . '</nrInsc>
                        </ideEmpregador>
                        <ideTransmissor>
                            <tpInsc>' . $this->tipoTransmissor . '</tpInsc>
                            <nrInsc>' . removeDigits($this->inscricaoTransmissor) . '</nrInsc>
                        </ideTransmissor>
                        <eventos>';
    }

    public function validarDados($dados){
        foreach($dados as $indice => $dado){
            if(is_null($dado) || $dados==""){
                throw new Exception("$indice em branco!");
            }
        }
    }

    public static function getCondicoesWhere($search_field_filter){
        if (!is_null($search_field_filter)) {
            if ($search_field_filter == "nao_enviados") {
                return " (esocial_lote_protocolo IS NULL OR (esocial_lote_acao='Enviar' AND esocial_lote_status='Erro') OR (esocial_lote_acao='Excluir' AND esocial_lote_status='Sucesso'))";
            } else if ($search_field_filter == "enviados") {
                return " ((esocial_lote_acao='Alterar' AND esocial_lote_status<>'Em processamento') OR (esocial_lote_acao='Enviar' AND esocial_lote_status='Sucesso') OR (esocial_lote_acao='Excluir' AND esocial_lote_status='Erro'))";
            }
        }else{
            return '';
        }
    }

    public function getXMLRodape(){
        return '</eventos></envioLoteEventos></eSocial>';
    }

    public function encapsularXMLEnvio($xml){
        return '<ns1:EnviarLoteEventos>'.$xml.'</ns1:EnviarLoteEventos>';
    }

    public function getInscricaoEmpregador(){
        if ($this->isInscricaoCompleta()) {
            return $this->limparInscricao($this->inscricaoEmpregador);
        } else {
            return substr($this->limparInscricao($this->inscricaoEmpregador), 0, 8);
        }
    }

    private function limparInscricao($string){
        $string = str_replace(".","",$string);
        return str_replace("-","",$string);
    }

    public function getProtocoloEnvio($resultado){
        return $resultado->retornoEnvioLoteEventos->dadosRecepcaoLote->protocoloEnvio ?? throw new Exception("Erro ao obter protocolo de envio!");
    }

}
