<?php
class Mensagem
{
    static function alerta($type, $msg, $return = false)
    {
        $mensagem = "";
        if ($type == "Success") {
            $mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
        } else if ($type == "Alert") {
            $mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
        } else if ($type == "Info") {
            $mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
        } else {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }

    static function toast($type, $msg, $return = false)
    {
        $mensagem = "";
        if ($type == "Success") {
            $mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
        } else if ($type == "Alert") {
            $mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
        } else if ($type == "Info") {
            $mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
        } else {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }

    static function feedback($type, $msg,  $number = null)
    {
        $feedback["msg_type"] = $type;
        $feedback["msg_number"] = $number;
        $feedback["msg_string"] = $msg;
        echo json_encode($feedback, JSON_PRETTY_PRINT);
    }

    static function ErrorSQL($msg)
    {
        $field = explode("'", $msg);
        $field_value = $field[1] ?? null;

        $sql_error["error_type"] = "sql";
        if (strpos($msg, 'foreign key')) {
            $sql_error["error_msg"] = "N&atilde;o foi possivel completar a opera&ccedil;&atilde;o, Chave estrangeira não encontrada ou existem outros registros utilizando este item.";
        } else if (strpos($msg, 'Duplicate entry')) {
            $fiel_key = substr($field[3], 0, -7);
            $sql_error["error_msg"] = "O valor digitado para o campo $fiel_key ja existe no banco de dados, por favor verifique os dados!";
        } else if (strpos($msg, 'cannot be null')) {
            $sql_error["error_msg"] = "<b>$field_value</b> não foi preenchido, por favor verifique os dados!";
        } else if (strpos($msg, 'Unknown database')) {
            $sql_error["error_msg"] = "Banco de dados não encontrado. Por favor informe o desenvolvedor!";
        } else if (strpos($msg, 'Base table or view not found')) {
            $sql_error["error_msg"] = "Tabela não encontrada. Por favor informe o desenvolvedor!";
        } else if (strpos($msg, 'Numeric value out of range')) {
            $sql_error["error_msg"] = "Existe um ou mais campos com comprimento acima do esperado!";
        } else {
            $sql_error["error_msg"] = "Algo saiu errado, Por favor informe o desenvolvedor";
        }
        $sql_error["original_msg"] = $msg;
        echo json_encode($sql_error);
    }

    static function dica($texto)
    {
        return '<span class="dica" data-tooltip="' . $texto . '" data-inverted=""><i class="question circle icon"></i></span>';
    }
}
