<?php
class Regex
{
    static function converterFormulario($dados)
    {
        $data = '/(\d\d\d\d)-(\d\d)-(\d\d)/ms';
        $dados = preg_replace($data, '$3/$2/$1', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter as datas");
            exit();
        }
        $select1 = "/(<select.*?<\/select>)/ms";
        $select2 = '/(?><select.*?name=")(.*?)"(?>(?>.*?value="([^"]*)".selected.*?<\/select>)|(?>( ).*?<\/select>))/ms';
        preg_match_all($select1, $dados, $resultado, PREG_PATTERN_ORDER);
        foreach ($resultado[0] as $html_select1) {
            $html_select2 = preg_replace($select2, '<div class="input simulated" name="$1">$2</div>', $html_select1);
            $dados = str_replace($html_select1, $html_select2, $dados);
            if ($dados == "") {
                Mensagem::alerta("Error", "Erro ao converter um select do tipo enum!");
                exit();
            }
        }
        $select_fk = '/<div.id="(.*?)".*?class="ui search selection dropdown".*?text">([^"]*)<\/div>.*?<\/div>/ms';
        $dados = preg_replace($select_fk, '<div class="input simulated" name="$1">$2</div>', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um select do tipo FK!");
            exit();
        }
        $calendario = '/(?><div class="ui calendar.*?<input.*?name=")(.*?)(?>".*?value=")(.*?)(?>".*?\/div.*?\/div>)/ms';
        $dados = preg_replace($calendario, '<div class="input simulated" name="$1">$2</div>', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um input de calendário!");
            exit();
        }
        $arquivo = '/<div class="ui file.*?<\/div>/ms';
        $dados = preg_replace($arquivo, '', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um input de arquivo!");
            exit();
        }
        $input = '/<input.*type="(?!hidden).*name="(.*)".*value="(.*)".*?>/m';
        $dados = preg_replace($input, '<div class="input simulated" name="$1">$2</div>', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um input comum!");
            exit();
        }
        $input = '/<td class="one wide field"><button(.*)".*?<\/button><\/td>/m';
        $dados = preg_replace($input, '', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um input comum!");
            exit();
        }
        $input = '/<th(.*?)EXCLUIR(.*?)<\/th>/m';
        $dados = preg_replace($input, '', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter um input comum!");
            exit();
        }
        $textarea = '/<textarea.*name="(.*?)".*?>(.*)<\/textarea>/m';
        $dados = preg_replace($textarea, '<div class="input simulated" name="$1">$2</div>', $dados);
        if ($dados == "") {
            Mensagem::alerta("Error", "Erro ao converter uma textarea!");
            exit();
        }
        // debug_xml($dados);
        $dados = str_replace("Selecione...", "", $dados);
        return $dados;
    }
}
