<?php
class Tempo
{

    public $anos;
    public $meses;
    public $dias;

    public function __construct($anos = 0, $meses = 0, $dias = 0)
    {
        $this->anos = $anos;
        $this->meses = $meses;
        $this->dias = $dias;
    }

    public function somar($tempo)
    {
        $this->anos += $tempo->anos;
        $this->meses += $tempo->meses;
        $this->dias += $tempo->dias;
        $this->ajustar();
    }

    public function subtrair($tempo)
    {
        $this->anos -= $tempo->anos;
        $this->meses -= $tempo->meses;
        $this->dias -= $tempo->dias;
        $this->ajustar();
    }

    private function ajustar()
    {
        if ($this->dias >= 30) {
            $qtd = floor($this->dias / 30);
            $this->dias -= 30 * $qtd;
            $this->meses += $qtd;
        }
        if ($this->meses >= 12) {
            $qtd = floor($this->meses / 12);
            $this->meses -= 12 * $qtd;
            $this->anos += $qtd;
        }
        if ($this->dias < 0) {
            $this->dias += 30;
            $this->meses--;
        }
        if ($this->meses < 0) {
            $this->meses += 12;
            $this->anos--;
        }
    }

    public static function getIntervalo($inicio, $fim, $rpps = true)
    {
        if (is_string($inicio)) {
            $inicio = new DateTime($inicio);
        }
        if (is_string($fim)) {
            $fim = new DateTime($fim);
        }
        $tempo = new Tempo();
        $intervalo = $fim->diff($inicio);
        $tempo->anos = $intervalo->y;
        $tempo->meses = $intervalo->m;
        $intervalo->d++;
        $tempo->dias = $intervalo->d;
        if ($rpps) {
            $bisextos = range($inicio->format('Y'), $fim->format('Y'));
            foreach ($bisextos as $bisexto) {
                if (date('L', strtotime("$bisexto-01-01"))) {
                    $tempo->dias++;
                }
            }
        }
        $tempo->ajustar();
        return $tempo;
    }

    public function __toString()
    {
        return $this->anos . " anos, " . $this->meses . " meses, " . $this->dias . " dias";
    }
}
