<?php
class UploadFile
{

    // Função para upload do arquivo
    public static function sendRestrictedFiles($dir, $file, $fileName, $allowedFiles, $newFileName = null)
    {
        if (!is_dir($dir)) {
            mkdir($dir,  0777, true);
        }
        if ($file['error'] == 0) {

            $ext = explode('.', $file['name']);
            $nome = str_replace(" ", "", $ext[0]);
            $ext = end($ext);
            $allowedFiles = strtoupper($allowedFiles);
            $allowedFiles = str_replace(" ", "", $allowedFiles);
            $allowedFiles = explode(",", $allowedFiles);

            if (in_array(strtoupper($ext), $allowedFiles)) {
                // gera o novo nome
                if (is_null($newFileName)) {
                    if ($fileName == "default") {
                        $newFileName = date('Ymdhis') . "-" . rand(0, 999) . '.' . $ext;
                    } else {
                        $newFileName = $fileName . "-" . rand(0, 999) . '.' . $ext;
                    }
                }
                if (move_uploaded_file($file['tmp_name'], $dir . '/' . $newFileName)) {
                    return $newFileName;
                } else {
                    // gera exceção para informar o erro
                    throw new Exception("Erro ao enviar o arquivo!");
                }
            } else {
                $c = count($allowedFiles);
                $extensions = null;
                for ($i = 0; $i < $c; $i++) {
                    if ($i != ($c - 1)) {
                        $extensions .= $allowedFiles[$i] . ", ";
                    } else {
                        $extensions .= $allowedFiles[$i] . ".";
                    }
                }
                msg("Error", "Formato de arquivo invalido, Formatos aceitos: " . strtoupper($extensions));
                exit(0);
            }
        } else {
            return null;
        }
    }

    // Função para upload do arquivo
    public static function sendFiles($dir, $file, $fileName, $newFileName = null)
    {
        $controle = rand(0, 999);
        if (!is_dir($dir)) {
            mkdir($dir,  0755, true);
        }
        if ($file['error'] == 0) {
            $ext = explode('.', $file['name']);
            $ext = end($ext);
            $path_file = explode('/', $fileName);
            $path_file = end($path_file);

            // gera o novo nome
            if (is_null($newFileName)) {
                if ($fileName == "default") {
                    $newFileName = date('Ymdhis') . "-" . $controle . '.' . $ext;
                } else {
                    $newFileName = str_replace($ext, '', $path_file) . "-" . $controle . '.' . $ext;
                }
                $caminho_arquivo = str_replace($ext, '', $fileName) . "-" . $controle . '.' . $ext;
            }

            if (move_uploaded_file($file['tmp_name'], $dir . '/' . $newFileName)) {
                return $caminho_arquivo;
            } else {
                // gera exceção para informar o erro
                throw new Exception("Erro ao enviar o arquivo!");
            }
        } else {
            return null;
        }
    }
    // Função para upload do arquivo
    public static function sendImageBase64($dir, $file, $fileName, $newFileName = null)
    {
        if (!is_dir($dir)) {
            mkdir($dir,  0777, true);
        }
        if ($file) {
            $image_parts = explode(";base64,", $file);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
            $image_base64 = base64_decode($image_parts[1]);

            // gera o novo nome
            if (is_null($newFileName)) {
                if ($fileName == "default") {
                    $newFileName = date('Ymdhis') . "-" . rand(0, 999) . '.' . $image_type;
                } else {
                    $newFileName = $fileName . "-" . rand(0, 999) . '.' . $image_type;
                }
            }
            //escreve o arquivo no diretório
            if (file_put_contents($dir . $newFileName, $image_base64)) {
                return $newFileName;
            } else {
                // gera exceção para informar o erro
                throw new Exception("Erro ao gravar arquivo!");
            }
        } else {
            return null;
        }
    }

    static function removeFiles($path, $find)
    {
        $files = glob($path . '/*');
        foreach ($files as $file) {
            if (!is_dir($file)) {
                if (str_contains($file, $find)) {
                    unlink($file);
                }
            }
        }
        return;
    }
}
