<?php
class XML extends Database
{
    private $xml;

    public function __construct()
    {
        $this->xml = new SimpleXMLElement('<xml/>');
    }

    public function addGrupo($grupo){
        return $this->xml->addChild($grupo);
    }

    public function addSubGrupo($grupo,$subgrupo){
        return $grupo->addChild($subgrupo);
    }

    public function addItem($grupo,$item,$valor){
        if(is_null($valor) || $valor==""){
            throw new Exception("O item $item está em branco!");
        }
        $grupo->addChild($item, $valor);
    }

    public function __toString(){
        preg_match_all('/<xml>(.*)<\/xml>/m', $this->xml->asXML(), $resultado, PREG_SET_ORDER, 0);
        return $resultado[0][1];
    }

}
