<?php
class Msg
{
    static function alerta($type, $msg, $return = false)
    {
        $mensagem = "";
        if ($type == "Success") {
            $mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
        } else if ($type == "Alert") {
            $mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
        } else if ($type == "Info") {
            $mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
        } else {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }
    static function toast($type, $msg, $JSON_output = false, $return = false)
    {
        $mensagem = "";
        $feedback = array();
        if ($type == "Success") {
            $mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
        } else if ($type == "Alert") {
            $mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
        } else if ($type == "Info") {
            $mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        } else {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        }
        if ($JSON_output) {
            $feedback["msg_type"] = $type;
            $feedback["msg_string"] = $mensagem;
            echo json_encode($feedback, JSON_PRETTY_PRINT);
            exit();
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }

    static function mensagem($type, $msg, $return = false)
    {
        $mensagem = "";
        if ($type == "Success"  || $type == "Sucesso") {
            $mensagem = '<div class="ui success center aligned message">' . $msg . '</div>';
        } else if ($type == "Alert") {
            $mensagem = '<div class="ui warning center aligned message">' . $msg . '</div>';
        } else if ($type == "Info") {
            $mensagem = '<div class="ui info center aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        } else {
            $mensagem = '<div class="ui red center aligned message">' . $msg . '</div>';
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }

    static function feedback($type, $msg,  $number = null)
    {
        $feedback["msg_type"] = $type;
        $feedback["msg_number"] = $number;
        $feedback["msg_string"] = $msg;
        echo json_encode($feedback, JSON_PRETTY_PRINT, JSON_UNESCAPED_UNICODE);
    }


    static function errorPHP($type, $msg, $return = false)
    {
        $mensagem = "";
        if ($type == "Alert") {
            if (strpos($msg, 'Undefined variable')) {
                $msg = str_replace("Undefined variable", "variável não definida: ", $msg);
            }
            $mensagem = '<div class="ui warning aligned message">' . $msg . '</div>';
        } else if ($type == "Error") {
            $mensagem = '<div class="ui red left aligned message">' . $msg . '</div>';
        }
        if ($return) {
            return $mensagem;
        } else {
            echo $mensagem;
        }
    }


    static function ErrorSQL($msg)
    {
        $sql_error["error"] = "yes";
        if (strpos($msg, 'foreign key')) {
            $sql_error["error_msg"] = "N&atilde;o foi possivel completar a opera&ccedil;&atilde;o, Chave estrangeira não encontrada ou existem outros registros utilizando este item.";
        } else if (strpos($msg, 'Duplicate entry')) {
            $sql_error["error_msg"] = "Há campo(s) duplicado(s) no banco de dados, por favor verifique os dados!";
        } else if (strpos($msg, 'cannot be null')) {
            $sql_error["error_msg"] = "Algum campo obrigatório não foi preenchido, por favor verifique os dados!";
        } else if (strpos($msg, 'Unknown database')) {
            $sql_error["error_msg"] = "Banco de dados não encontrado. Por favor informe o desenvolvedor!";
        } else if (strpos($msg, 'Base table or view not found')) {
            $sql_error["error_msg"] = "Tabela não encontrada. Por favor informe o desenvolvedor!";
        } else {
            $sql_error["error_msg"] = "Algo saiu errado, Por favor informe o desenvolvedor";
        }
        $sql_error["original_msg"] = $msg;
        echo json_encode($sql_error);
    }
}
