<?php
class Compra extends Database
{
	public function __construct()
	{
		$this->tabela = "compra";
		$this->chave_primaria = "compra_id";
		$this->order_by = "compra_frigorifico ASC";
		$this->join = [
			1 => array(
				"tabela" => "comprador",
				"fk" => "compra_comprador",
				"pk" => "comprador_id",
				"colunas" => "*"
			),
			2 => array(
				"tabela" => "fazenda",
				"fk" => "compra_fazenda",
				"pk" => "fazenda_id",
				"colunas" => "*"
			),
			3 => array(
				"tabela" => "pecuarista",
				"tabelafk" => "fazenda",
				"fk" => "fazenda_pecuarista",
				"pk" => "pecuarista_id",
				"colunas" => "*"
			),
			4 => array(
				"tabela" => "frigorifico",
				"fk" => "compra_frigorifico",
				"pk" => "frigorifico_id",
				"colunas" => "*"
			),
			5 => array(
				"tabela" => "cidade",
				"tabelafk" => "frigorifico",
				"fk" => "frigorifico_cidade",
				"pk" => "cidade_id",
				"colunas" => "*"
			)
		];
	}
}
