<?php
require_once('autoload.php');
if (Configuracao::$log_sql) {
    ob_start();
}
if (count($url) > 1 && !file_exists("modulos" . $url_nav . ".php")) {
    http_response_code(404);
    die(include_once('404.php'));
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<?php require_once 'header.php' ?>

<body>
    <!-- ? Preloader Start -->
    <div id="preloader-active">
        <div class="preloader">
            <div class="preloader-inner position-relative">
                <div class="preloader-circle"></div>
                <div class="preloader-img preloader-text">
                    <img src="<?= $url_site; ?>/imagens/layout/logo_default.png" alt="">
                </div>
            </div>
        </div>
    </div>

    <!-- Preloader end -->
    <div id="container" class="fluid">
        <div class="ui menu system">
            <div class="logo">
                <a href="<?= $url_site ?>">
                    <img src="<?= $url_site ?>imagens/layout/logo_default.png" height="75px" alt="Logo">
                </a>
            </div>

            <style>
                .sandwich {
                    position: absolute;
                    top: 15px;
                    right: 27.5px;
                }

                .sandwich .icon {
                    margin: 20px;
                }

                /* nav-icon-2 */
                .sandwich>.nav-icon {
                    width: 35px;
                    height: 30px;
                    margin: 10px 10px;
                    cursor: pointer;
                    display: inline-block;
                    position: relative;
                }

                .sandwich>.nav-icon span {
                    background-color: #000;
                    position: absolute;
                    border-radius: 2px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                }

                .sandwich>.nav-icon span:nth-child(1) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    top: 0px;
                    left: 0px;
                }

                .sandwich>.nav-icon span:nth-child(2) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    top: 13px;
                    left: 0px;
                }

                .sandwich>.nav-icon span:nth-child(3) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    bottom: 0px;
                    left: 0px;
                }

                .sandwich>.nav-icon:not(.open):hover span:nth-child(1) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    top: -2px;
                    left: 0px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                }

                .sandwich>.nav-icon:not(.open):hover span:nth-child(2) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    top: 13px;
                    left: 0px;
                    transition: .4s cubic-bezier(.8, .5, .2, 1.4);
                }

                .sandwich>.nav-icon:not(.open):hover span:nth-child(3) {
                    width: 100%;
                    height: 4px;
                    display: block;
                    bottom: -2px;
                    left: 0px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                }

                .sandwich>.nav-icon.open span:nth-child(1) {
                    left: 3px;
                    top: 12px;
                    width: 30px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                    transform: rotate(90deg);
                    transition-delay: 150ms;
                }

                .sandwich>.nav-icon.open span:nth-child(2) {
                    left: 2px;
                    top: 20px;
                    width: 20px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                    transform: rotate(45deg);
                    transition-delay: 50ms;
                }

                .sandwich>.nav-icon.open span:nth-child(3) {
                    left: 14px;
                    top: 20px;
                    width: 20px;
                    transition: .3s cubic-bezier(.8, .5, .2, 1.4);
                    transform: rotate(-45deg);
                    transition-delay: 100ms;
                }

                .menu-itens {
                    position: fixed;
                    top: 15px;
                    right: 77.5px;
                    width: 200px;
                    background-color: #FFF;
                    border: 2px solid #CCC;
                    height: auto;
                    border-radius: 5px !important;
                    display: none;
                    padding: 7.5px;
                }

                .menu-item {
                    width: 100% !important;
                    text-align: left !important;
                    border-radius: 5px !important;
                    margin: 2px !important;
                }
            </style>
            <div class='sandwich'>
                <div class="nav-menu nav-icon">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="menu-itens">
                    <a class="ui button red menu-item" href="<?= $url_site ?>logout.php">
                        <i class="fas fa-times"></i> Sair
                    </a>
                </div>
            </div>
            <script>
                $('.nav-menu').on('click', function() {
                    $(this).toggleClass('open');
                    if ($(this).hasClass('open')) {
                        $('.menu-itens').slideDown();
                    } else {
                        $('.menu-itens').slideUp();
                    }
                });
            </script>
        </div>
        <div class="row clearfix" id="content">

            <div class="body_system">
                <?php
                if (count($url) > 1) {
                    include "modulos/" . $url_nav . ".php";
                } else {
                    include "home.php";
                }
                ?>
            </div>
        </div>

        <div class="ui footer segment centered grid">
            <div class="ui infoLogin">
                <?= "Usuário: " . $_SESSION['usuario_nome'] ?>
            </div>
        </div>
    </div>
    <?php
    include "modal.php";
    ?>
</body>

</html>
<?php
if (Configuracao::$log_sql) {
    ob_end_flush();
}
?>