<?php require_once "autoload.php";
if (phpversion() < '8.2') {
	echo '<div class="text-white" style="text-align: center">
		<h1>VERSÃO PHP NÃO SUPORTADA</h1>
		<h2>Atualize a versão do servidor PHP para 8.2 ou superior</h2>
	</div>';
	exit();
}

if ($_POST) {
	$usuario_login = filter_input(INPUT_POST, "usuario_login");
	$usuario_senha = filter_input(INPUT_POST, "usuario_senha");

	$usuario = new Usuario();
	$usuario->and("usuario_cpf", Funcao::ConvertToInt($usuario_login));
	$usuario->and("usuario_senha", md5($usuario_senha));
	$usuario->and("usuario_status", 'Liberado');
	$usuario = $usuario->consultar();

	if ($usuario) {
		$_SESSION["usuario_id"] = $usuario->usuario_id;
		$_SESSION["usuario_nome"] = $usuario->usuario_nome;
		$_SESSION["usuario_status"] = $usuario->usuario_status;

		echo "<script language='javascript'>location.href='" . __URLSITE__ . "';</script>";
		echo "<script>
		var url = '" . __URLSITE__ . "';
		$(location).attr('href',url);
		</script>";
		exit(0);
	} else {
		echo "<script language='javascript'>location.href='" . __URLSITE__ . "login.php?error=true';</script>";
		echo "<script>
		var url = '" . __URLSITE__ . "login.php?error=true';
		$(location).attr('href',url);
		</script>";
		exit(0);
	}
} else {
	$error = $_GET['error'] ?? '';
	if ($_GET['error'] ?? 'true') {
		$erro_login = "Usuário e/ou senha incorreto(s) !";
	}
?>
	<!DOCTYPE html>
	<html lang="pt-br">
	<?php require_once 'header.php' ?>

	<body>
		<div class="login-reg-panel">
			<div class="logo_box">
				<div class="ui center aligned">
					<img src="imagens/layout/login.png" alt="Logo" style="width: 240px">
				</div>
			</div>

			<div class="white-panel">
				<div class="login-show">
					<div class="ui relaxed padded center aligned grid logo_form">
						<img src="imagens/layout/logo_login.png" alt="Logo" style="width: 220px">
					</div>

					<div class="ui segment relaxed padded">
						<form class="ui large form" method="post" action="">
							<div class="ui segment">
								<div class="field">
									<div class="ui left icon input">
										<i class="user icon"></i>
										<input type="text" name="usuario_login" class="cpf" placeholder="Usuário">
									</div>
								</div>
								<div class="field">
									<div class="ui left icon input">
										<i class="lock icon"></i>
										<input type="password" name="usuario_senha" placeholder="Senha" id="usuario_senha">
									</div>
								</div>
							</div>
							<button class=" ui large login_button button" type="submit">Entrar</button>
						</form>
					</div>
				</div>
			</div>
		</div>

		<?php if ($error != '') { ?>
			<script>
				$(document).ready(function() {
					$('body').toast({
						className: {
							toast: 'ui message'
						},
						class: 'error center aligned',
						position: 'bottom center',
						title: 'Solicitação Inválida',
						message: '<?= $erro_login ?>',
						displayTime: 6000,
						showProgress: 'bottom'
					});
				});
			</script>
		<?php } ?>
		<script>
			$(document).ready(function() {
				init_plugin_mask();
				$('.login-info-box').fadeOut();
				$('.login-show').addClass('show-log-panel');
			});

			$('.login-reg-panel input[type="radio"]').on('change', function() {
				if ($('#log-login-show').is(':checked')) {
					$('.register-info-box').fadeOut();
					$('.login-info-box').fadeIn();

					$('.white-panel').addClass('right-log');
					$('.register-show').addClass('show-log-panel');
					$('.login-show').removeClass('show-log-panel');

				} else if ($('#log-reg-show').is(':checked')) {
					$('.register-info-box').fadeIn();
					$('.login-info-box').fadeOut();

					$('.white-panel').removeClass('right-log');

					$('.login-show').addClass('show-log-panel');
					$('.register-show').removeClass('show-log-panel');
				}
			});

			$('.ui.form')
				.form({
					inline: true,
					fields: {
						usuario_login: {
							identifier: 'usuario_login',
							rules: [{
								type: 'empty',
								prompt: 'Você deve informar um usuário!'
							}]
						},
						usuario_senha: {
							identifier: 'usuario_senha',
							rules: [{
								type: 'empty',
								prompt: 'Você deve informar uma senha!'
							}]
						}
					}
				});
		</script>
	</body>

	</html>
<?php } ?>
<style>
	body {
		background-image: url('imagens/layout/background.png');
		background-repeat: no-repeat;
		background-size: cover;
		background-color: #2e2d37;
	}

	#login {
		width: 450px;
		background-color: azure;
		-webkit-border-radius: 10px;
		-moz-border-radius: 10px;
		border-radius: 10px;
		padding: 20px;
		-webkit-box-shadow: 0px 0px 20px 5px rgba(0, 0, 0, 0.75);
		box-shadow: 0px 0px 20px 5px rgba(0, 0, 0, 0.75);
		position: absolute;
		left: 50vw;
		top: 50vh;
		transform: translate(-50%, -50%);
	}

	@media screen and (max-width: 700px) {
		#login {
			width: 95vw;
			min-width: 350px;
		}
	}

	.text-white {
		color: #FFFFFF !important;
	}
</style>