<div id="mainModal" class="ui mini modal">
	<div class="header" id="mainModalTitle"></div>
	<div class="scrolling content">
		<div id="mainModalLoading">
			<div class="ui active centered inline text loader">Enviando dados...</div>
			<div class="percent"></div>
		</div>
		<div id="mainModalContent"></div>
	</div>
	<div class="actions">
		<div id="btnFechar" class="ui cancel button">Fechar</div>
		<div id="btnEnviar" class="ui primary button">Gravar dados</div>
	</div>
</div>
<div id="formError" class="ui mini modal ">
	<div class="header mainModalTitle">Erro na solicitação</div>
	<div class="scrolling content feedback">
		<div class="mainModalContent"></div>
	</div>
	<div class="actions">
		<div id="btnFechar" class="ui cancel button">Fechar</div>
	</div>
</div>


<div id="modalFeedback" class="ui mini modal ">
	<div class="header modalTitle"></div>
	<div class="scrolling content feedback">
		<div class="modalContent"></div>
	</div>
	<div class="actions">
		<div id="btnFechar" class="ui cancel button">Fechar</div>
	</div>
</div>

<div class="ui modal modaldel mini">
	<div class="header">
		Excluir Registro
	</div>
	<div class="content">
		Deseja realmente excluir este registro?
	</div>
	<div class="actions">
		<div class="ui button cancel grey">Fechar</div>
		<div class="ui button approve red" onclick="del(this)">Excluir</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$('#formError').modal({
			allowMultiple: true,
			blurring: true,
			closable: false
		});
		$('#modalFeedback').modal({
			blurring: true,
			closable: false
		});
		$('#mainModal').modal({
			closable: false
		});
	});
	// Simulação do botao Enviar 
	$('#btnEnviar').on('click', function(event) {
		$('button[name="send_form"]').click();
	});

	function closemodal() {
		setTimeout(() => {
			$('.cancel').click();
		}, 2000);
	}

	function mainModalSize(size) {
		$("#mainModal").removeClass("mini");
		$("#mainModal").removeClass("small");
		$("#mainModal").removeClass("medium");
		$("#mainModal").removeClass("large");
		$("#mainModal").removeClass("fullscreen");
		if (size == 'small') {
			$("#mainModal").addClass("mini");
		} else if (size == "medium") {
			$("#mainModal").addClass("small");
		} else if (size == "big") {
			$("#mainModal").addClass("medium");
		} else if (size == "large") {
			$("#mainModal").addClass("large");
		} else {
			$("#mainModal").addClass("fullscreen");
		}
	}

	function mainModalTitle(titulo) {
		$("#mainModal").find('#mainModalTitle').html('<strong>' + titulo + '</strong>');
	}

	function mainModalLoadingStart() {
		mainModalSize('small');
		$("#btnFechar").hide();
		$("#btnEnviar").hide();
		$("#mainModalContent").hide();
		$("#mainModalLoading").show();
	}

	function mainModalLoadingEnd(size) {
		mainModalSize(size);
		$("#mainModalLoading").hide();
		$("#mainModalContent").show();
		$("#btnFechar").show();
	}

	function enviarLote() {
		var check = $(".itens");
		$("#selecionarTudo").prop("checked", check.length == check.filter(":checked").length);
		if (check.is(":checked")) {
			$("#enviarLote").removeClass("disabled");
		} else {
			$("#enviarLote").addClass("disabled");
		}
	}

	function selecionarTudo(elemento) {
		$(".itens").prop("checked", elemento.checked);
		enviarLote();
	}
</script>