<?php include_once '../../autoload.php';
header('Content-Type:application/json; charset=utf-8');
$abates = (new Compra())
    ->colunas('
        compra_id,
        compra_data_abate,
        fazenda_nome,
        frigorifico_nome,
        cidade_nome,
        cidade_uf,
        compra_gado_total,
        pecuarista_nome
    ')
    ->customSelect(1)
    ->distinct(1)
    ->listar();

$agenda = (new Agenda())
    ->colunas("
        agenda_id as compra_id,
        agenda_data as compra_data_abate,
        '' as fazenda_nome,
        agenda_texto as frigorifico_nome,
        '' as cidade_nome,
        '' as cidade_uf,
        '' as compra_gado_total,
        agenda_titulo as pecuarista_nome
    ")
    ->customSelect(1)
    ->distinct(1)
    ->listar();

$dados = array_merge($abates, $agenda);
$calendario = [];
foreach ($dados as $key => $abate) {
    if ($abate->cidade_nome != '') {
        $descricao = '
            Fazenda: ' . $abate->fazenda_nome . ' <br> 
            Frigorifico: ' . $abate->cidade_nome . ' - ' . $abate->cidade_uf  . '
            <p>
                <a href="' . __URLSITE__ . 'modulos/compras/compromisso.php?procotolo=' . $abate->compra_id . '" target="_blank" rel="noopener noreferrer">
                    Total de ' . $abate->compra_gado_total . ' Cabeças
                </a>
            </p>';
    } else {
        $descricao = substr($abate->frigorifico_nome, 0, 100) . ' ...';
        $abate->pecuarista_nome = 'AGENDA -> ' . $abate->pecuarista_nome;
    }

    if ($abate->compra_data_abate != '') {
        $data_abate = new DateTime($abate->compra_data_abate);
        $data_abate->modify('+1 day');
        $calendario[] = array(
            "id" => $abate->compra_id,
            "description" => $descricao,
            "name" => $abate->pecuarista_nome,
            "date" =>  $data_abate->format('Y-m-d'),
            "type" => "event"
        );
        unset($data_abate);
    }
}
echo json_encode($calendario, JSON_PRETTY_PRINT);
