<?php require_once("../../autoload.php");
$compromisso = (new Compra)
    ->and("compra_id", $_GET["procotolo"])
    ->consultar();

$conta = (new PecuaristaConta)
    ->and('pecuarista_conta_preferencial', 'Sim')
    ->and('pecuarista_conta_pecuarista', $compromisso->pecuarista_id)
    ->consultar();
$fazenda = (new Fazenda)
    ->pk($compromisso->compra_fazenda)
    ->consultar();


// Caminho para a imagem PNG com perfil ICC
$imageLogoICC = ROOT . '/imagens/layout/logo_default.png';

// Carrega a imagem usando a GD e remove o perfil ICC
$logo = imagecreatefrompng($imageLogoICC);
imagealphablending($logo, false);
imagesavealpha($logo, true);
imagepng($logo, $imageLogoICC);
imagedestroy($logo);

$imageAviso = ROOT . '/imagens/report/tabela_aviso_compra.jpg';


$header = '<div style="width:100%;">
    <div style="width:28%; float:left;">
        <img src="' . $imageLogoICC . '" width="180px">
    </div>  
    <div style="width:70%; float:right; text-align:right; height:15px;">
        <h4 style="padding-top:12.5px;"> COMPRA Nº  ' . str_pad($compromisso->compra_id, 5, 0, STR_PAD_LEFT) . '</h4>
    </div> 
    <div class="clear"></div>
</div>';

$compra_descricao = '';
$lista_descricao = (new CompraDescricao)->and('compra_descricao_compra', $compromisso->compra_id)->listar(0);
foreach ($lista_descricao as $descricao) {
    $compra_descricao .= '<tr>';
    $compra_descricao .= '<td valign="top">' . $descricao->compra_descricao_gado_tipo . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_origem . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_classificacao . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_idade . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_valor_arroba . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_tipo_bonificacao . '</td>';
    $compra_descricao .= '<td class="text-center">' . $descricao->compra_descricao_quantidade . '</td>';
    $compra_descricao .= '</tr>';
}


$compra_embarque = '';
$lista_transporte = (new CompraEmbarque)->and('compra_embarque_compromisso', $compromisso->compra_id)->listar(2, 3);
foreach ($lista_transporte as $transporte) {
    $compra_embarque .= '<tr>';
    $compra_embarque .= '<td valign="top"><p><strong>' . $transporte->veiculo_tipo . '</strong></p><p>Placa: ' . $transporte->veiculo_placa . '</p></td>';
    $compra_embarque .= '<td valign="top"><p><strong>' . $transporte->motorista_nome . '</strong> </p><p>CPF: ' . Funcao::mask($transporte->motorista_cpf, '###.###.###-##') . ' | Celular: ' . $transporte->motorista_telefone . ' </p></td>';
    $compra_embarque .= '<td class="text-center"><p>' . $transporte->compra_embarque_quantidade_abrigada . ' </p></td>';
    $compra_embarque .= '</tr>';
}






$footer =  '
<table class="table_no_style">
<tr class="table_no_style">
    <td>Eduardo Scarceli</td>
    <td>Tatiana P. Scarceli</td>
    <td></td>
</tr>
<tr class="table_no_style">
<td>Cel e whats: (63) 98132-7979</td>
    <td>Cel e whats: (63) 98515-6000</td>
    <td>E-mail: scarceli.agronegocios@gmail.com</td>
</tr>
</table>
';


$html = '
<html>
<head>
<style>
    tr:not(.table_no_style):first-child {background: #FFFFFF;}
    tr:not(.table_no_style):nth-child(2n+2) {background: #d9d9d9;}
    td {
        padding: 5px 10px !important;
        font-size: 12px;      
    }
    tr {
        border: 1px solid black;
    }
    th {
        text-align: left !important;
        padding: 5px 10px !important;
        background-color:#ebedf0;
        color: #000;
    }
    table {
    width: 100%;
    }
    body {font-family: sans-serif;
        font-size: 10pt;
    }
    p {	margin: 0pt; }
    .clear{ clear:both; }
    .margin-0{margin-top:0px}
    .text-center{
        text-align:center;
    }

    .red{
        color:red;
        font-weight:900px;
    }

</style>
</head>
<body>
    <hr>
    <div style="text-align:center;">AVISO DE COMPRA </div>
    <hr>
    <div>
        <p>Sr.(ª) Pecuarista, gentilmente solicitamos que os documentos solicitados abaixo sejam emitidos conforme as seguintes orientações: </p>
        <p> <strong>OS DADOS DO FRIGORÍFICO E PECUARISTA QUE DEVEM CONSTAR NO GTA, DECLARAÇÃO MODELO B ∕ CARTA DE GARANTIA E NOTA FISCAL ESTÃO ABAIXO:</strong></p>

    </div>
    <div style="text-align:center;margin-top:5px">Dados do Frigorífico</div>
    <table border="1" cellspacing="0" cellpadding="0">
    <tr>
        <td colspan="8" valign="top">
        <p>Frigorífico: <strong>' . $compromisso->frigorifico_nome . '</strong></p>
        </td>
    </tr>
    <tr>
        <td colspan="5" valign="top"><p>Endereço: <strong> ' . $compromisso->frigorifico_endereco . '</strong> </p></td>
        <td colspan="3"  valign="top"><p>Cidade: <strong> ' . $compromisso->cidade_nome . ' - ' . $compromisso->cidade_uf . ' </strong> </p></td>
    </tr>
        <tr>
            <td colspan="2" valign="top"><p>CNPJ: <strong> ' . Funcao::mask($compromisso->frigorifico_cnpj, '##.###.###/####-##') . '</strong> </p></td>
            <td colspan="2" valign="top"><p>N° I.E.:  <strong> ' . Funcao::mask($compromisso->frigorifico_inscricao, '##.###.###-#') . '</strong> </p></td>
            <td colspan="2" valign="top"><p>TARE:  <strong> ' . $compromisso->frigorifico_tare . '</strong> </p></td>
            <td colspan="2" valign="top"><p>SIF:  <strong> ' . $compromisso->frigorifico_sif . '</strong> </p></td>
        </tr>
    </table>
    <div style="text-align:center;margin-top:10px">Dados do Pecuarista</div>
    <table border="1" cellspacing="0" cellpadding="0">
        <tr>
            <td colspan="6" valign="top"><p>NOME PECUARISTA: <strong>' . $compromisso->pecuarista_nome . '</strong></p></td>
        </tr>
        <tr>
            <td colspan="4" valign="top"><p>NOME FAZENDA: <strong> ' . $fazenda->fazenda_nome . '</strong></p></td>
            <td colspan="2" valign="top"><p>IE: <strong> ' . $fazenda->fazenda_inscricao . '</strong></p></td>
        </tr>
        <tr>
            <td colspan="3" valign="top"><p>DATA NEGOCIAÇÃO:  <strong> ' . Funcao::ConvertDateFromMysql($compromisso->compra_data_negociacao) . '</strong></p></td>
            <td colspan="3" valign="top"><p><TO:>CONDIÇÃO PAGTO:  <strong> ' . Funcao::ConvertDateFromMysql($compromisso->compra_data_pagamento) . '</strong></p></td>
        </tr>
        <tr>
            <td colspan="3" valign="top"><p>DATA EMBARQUE: <strong> ' . Funcao::ConvertDateFromMysql($compromisso->compra_data_embarque) . '</strong></p></td>
            <td colspan="3" valign="top"><p>DATA ABATE: <strong> ' . Funcao::ConvertDateFromMysql($compromisso->compra_data_abate) . '</strong></p></td>
        </tr>
    </table>

    <div style="text-align:center;margin-top:10px">Descrição da Compra</div>
    <table border="1" cellspacing="0" cellpadding="0">
        <tr>
            <th width="15%" valign="middle"><p><strong>TIPO DE GADO</strong></p></th>
            <th width="15%" class="text-center" valign="middle"><p><strong>ORIGEM</strong></p></th>
            <th width="10%" class="text-center" valign="middle"><p><strong>CLASSIFICAÇÃO</strong></p></th>
            <th width="15%" class="text-center" valign="middle"><p><strong>IDADE </strong></p></th>
            <th width="15%" class="text-center" valign="middle"><p><strong>VALOR @ </strong></p></th>
            <th width="20%" class="text-center" valign="middle"><p><strong>TIPO BONIFICAÇÃO </strong></p></th>
            <th width="10%" class="text-center" valign="middle"><p><strong>QTDE</strong></p></th>
        </tr>
            ' . $compra_descricao . '
        <tr>
            <td colspan="7" valign="top"><p>OBS.: </p></td>
        </tr>
    </table>

    <div style="text-align:left;margin-top:10px"><strong><em><u>1. GTA:</u></em></strong></div>
    <ul>
        <li><strong>A data de  validade deve ser ' . Funcao::ConvertDateFromMysql($compromisso->compra_data_abate) . ';</strong></li>
        <li><strong>Obrigatório que a assinatura do emissor seja feita EXCLUSIVAMENTE EM CANETA DE COR AZUL;</strong></li>
        <li>Os  dados do(a) Pecuarista e frigorífero precisam ser idênticos aos mencionados acima;</li>
        <li>Dados  do motorista e caminhão abaixo:</li>
    </ul>

    <div style="text-align:center;margin-top:10px">Dados Embarque/Abate</div>
    <table border="1" cellspacing="0" cellpadding="0">
    <tr>
        <th width="30%" valign="middle"><p><strong>VEÍCULO </strong></p></th>
        <th width="50%" valign="middle"><p><strong>MOTORISTA </strong></p></th>
        <th width="20%" class="text-center" valign="middle"><p><strong>QTDE ABRIGADA </strong></p></th>
    </tr>
    ' . $compra_embarque . '
    <tr>
        <td valign="top"><p><strong>TOTAL:</strong></p></td>
        <td class="text-center" valign="top"><p><strong>' . $compromisso->compra_quantidade_veiculos . ' Veiculo(s)</strong></p></td>
        <td class="text-center" valign="top"><p><strong>' . $compromisso->compra_quantidade_total_abrigada . '</strong></p></td>
    </tr>
    </table>

    <div style="text-align:left;margin-top:10px"><strong><em><u>2. Declaração Modelo B e Carta de Garantia:</u></em></strong>
    <ul>
        <li><strong>Obrigatório que a assinatura do emissor seja feita EXCLUSIVAMENTE EM CANETA DE COR AZUL;</strong></li>
        <li>Dados  do(a) Pecuarista sejam idênticos ao do GTA.</li>
    </ul>
    <div style="text-align:left;margin-top:10px"><strong><em><u>3. Nota Fiscal:</u></em></strong></div>
    <ul>
        <li>Data  de saída dos animais – <strong>Relação dos animais idêntica ao do GTA;</strong></li>
        <li>Dados  do(a) Pecuarista e do frigorÍfico idênticos aos mencionados no GTA.</li>
    </ul>  

    <div style="width:100%; text-align:center; margin-top:25px;">
        <img src="' . $imageAviso . '">
    </div>  
</body>
</html>';

$mpdf = new \Mpdf\Mpdf([
    'curlAllowUnsafeSslRequests' => true,
    'mode' => 'utf-8',
    'format' => 'A4-P',
    'orientation' => 'P',
    'margin_left' => 15,
    'margin_right' => 10,
    'margin_top' => 25,
    'margin_bottom' => 25,
    'margin_header' => 5,
    'margin_footer' => 5,
    'debug' => true
]);
$mpdf->showImageErrors = true;
$mpdf->SetHTMLHeader($header);
$mpdf->SetTitle("Aviso de Compra - " . str_pad($compromisso->compra_id, 5, 0, STR_PAD_LEFT));
$mpdf->SetAuthor("Scarceli - Gestão de Compras");
$mpdf->SetWatermarkText("Scarceli");
$mpdf->showWatermarkText = false;
$mpdf->watermark_font = 'DejaVuSansCondensed';
$mpdf->watermarkTextAlpha = 0.1;
$mpdf->SetDisplayMode('fullpage');
$mpdf->setFooter($footer . 'Página {PAGENO} de {nb}');
$mpdf->WriteHTML($html);
ob_clean();
$mpdf->Output('compromisso.pdf', 'I');
