<?php require_once("form_custom_header.php"); ?>
<?php
$frigorifico_padrao = (new Frigorifico)->and('frigorifico_principal', 'Sim')->consultar();

?>

<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="compra_id" value="<?= $data->compra_id ?? ''; ?>">
						<input type="text" name="compra_protocolo" value="<?= ($data->compra_protocolo != '' ? $data->compra_protocolo : GerarSenha::protocolo()); ?>">

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_frigorifico"); ?> </label>
							<div id="compra_frigorifico" class="ui selection dropdown">
								<input type="hidden" name="compra_frigorifico" value="<?= ($data->compra_frigorifico != '' ? $data->compra_frigorifico : $frigorifico_padrao->frigorifico_id) ?>" required>
								<?php
								if ($data->compra_frigorifico != "") {
									echo '<div class="text">' . $frigorifico_padrao->cidade_uf . '-' . $frigorifico_padrao->cidade_nome . ': ' . $frigorifico_padrao->frigorifico_nome . '</div>';
								} else {
									echo '<div class="default text">' . $frigorifico_padrao->cidade_uf . '-' . $frigorifico_padrao->cidade_nome . ': ' . $frigorifico_padrao->frigorifico_nome . '</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_comprador"); ?> </label>
							<div id="compra_comprador" class="ui search selection dropdown">
								<input type="hidden" name="compra_comprador" value="<?= $data->compra_comprador ?>" required>
								<?php
								if ($data->compra_comprador != "") {
									echo '<div class="text">' . $data->comprador_nome . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_fazenda"); ?> </label>
							<div id="compra_fazenda" class="ui search selection dropdown">
								<input type="hidden" name="compra_fazenda" value="<?= $data->compra_fazenda ?>" required>
								<?php
								if ($data->compra_fazenda != "") {
									echo '<div class="text">' . $data->pecuarista_nome . ' - ' . $data->fazenda_nome . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compromisso_desconta_fundo_rural"); ?> </label>
							<select name="compromisso_desconta_fundo_rural" class=" " required readonly>
								<option value="Sim" <?= ($data->compromisso_desconta_fundo_rural ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
								<option value="Não" <?= ($data->compromisso_desconta_fundo_rural ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_data_negociacao"); ?> </label>
							<div class="ui calendar inverted">
								<div class="ui input left icon">
									<i class="calendar icon"></i>
									<input type="text" minlength="10" maxlength="10" class="date" name="compra_data_negociacao" value="<?= $data->compra_data_negociacao ?? '' ?>">
								</div>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_data_embarque"); ?> </label>
							<div class="ui calendar inverted">
								<div class="ui input left icon">
									<i class="calendar icon"></i>
									<input type="text" minlength="10" maxlength="10" class="date" name="compra_data_embarque" value="<?= $data->compra_data_embarque ?? '' ?>">
								</div>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_data_abate"); ?> </label>
							<div class="ui calendar inverted">
								<div class="ui input left icon">
									<i class="calendar icon"></i>
									<input type="text" minlength="10" maxlength="10" class="date" name="compra_data_abate" value="<?= $data->compra_data_abate ?? '' ?>">
								</div>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_data_pagamento"); ?> </label>
							<div class="ui calendar inverted">
								<div class="ui input left icon">
									<i class="calendar icon"></i>
									<input type="text" minlength="10" maxlength="10" class="date" name="compra_data_pagamento" value="<?= $data->compra_data_pagamento ?? '' ?>">
								</div>
							</div>
						</div>



						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_endereco_mesmo"); ?> </label>
							<select name="compra_endereco_mesmo" class=" " required>
								<option value="">Selecione</option>
								<option value="Sim" <?= ($data->compra_endereco_mesmo ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
								<option value="Não" <?= ($data->compra_endereco_mesmo ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "compra_endereco_embarque"); ?> </label>
							<input type="text" maxlength="255" class=" " name="compra_endereco_embarque" value="<?= $data->compra_endereco_embarque ?? '' ?>" required>
						</div>
					</div>

					<div class="ui segment blue">
						<h1 class="ui header compra">DESCRIÇÃO DA COMPRA</h1>


						<div class="ui three column center aligned stackable divided grid">
							<div class=" field">
								<div class="ui slider checkbox">
									<input type="radio" name="compra_tipo_peso" value="Peso Vivo" checked="checked">
									<label>PESO VIVO</label>
								</div>
							</div>
							<div class="field">
								<div class="ui slider checkbox">
									<input type="radio" name="compra_tipo_peso" value="Peso Morto">
									<label>PESO MORTO </label>
								</div>
							</div>
							<div class="field">
								<div class="ui slider checkbox">
									<input type="radio" name="compra_tipo_peso" value="Peso Morto com Garantia">
									<label>COM GARANTIA</label>
								</div>
							</div>
						</div>
						<hr>

						<div class="ui grid fields relaxed stackable margin_bottom_field grid_table">
							<div class="layout four wide field">
								<label> <?= "Tipo de Gado" ?> </label>
								<select name="grid_compra_descricao_gado_tipo" class=" ">
									<option value="Macho">Macho</option>
									<option value="Fêmea">Fêmea</option>
									<option value="Marruco">Marruco</option>
								</select>
							</div>

							<div class="layout two wide field">
								<label> <?= "Origem" ?> </label>
								<select name="grid_compra_descricao_origem" class=" ">
									<option value="Normal">Normal</option>
									<option value="Europeu">Europeu</option>
									<option value="N/A">N/A</option>
								</select>
							</div>
							<div class="layout two wide field">
								<label> <?= "Classificação" ?> </label>
								<input type="text" maxlength="255" class=" " name="grid_compra_descricao_classificacao" value="">
							</div>

							<div class="layout two wide field">
								<label> <?= "Idade" ?> </label>
								<select name="grid_compra_descricao_idade" class=" ">
									<option value="0-12">0-12</option>
									<option value="13-24">13-24</option>
									<option value="25-36">25-36</option>
									<option value="36+">36+</option>
									<option value="N/A">N/A</option>
								</select>
							</div>
							<div class="layout two wide field">
								<label> <?= "Valor @" ?> </label>
								<input type="text" maxlength="255" class="money " name="grid_compra_descricao_valor_arroba" value="">
							</div>
							<div class="layout two wide field">
								<label> <?= "Tipo Bonificação" ?> </label>
								<input type="text" maxlength="255" class="" name="grid_compra_descricao_tipo_bonificacao" value="">
							</div>
							<div class="layout one wide field">
								<label> <?= "QTDE" ?> </label>
								<input type="text" maxlength="255" class="number" name="grid_compra_descricao_quantidade" value="">
							</div>
							<div class="layout one wide field">
								<label> <?= "Adicionar" ?> </label>
								<button type="button" class="ui button blue adicionar_gado"><i class="fas fa-plus"></i></button>
							</div>
						</div>
						<hr>
						<table class="ui table tabela_gado" border="1" cellspacing="0" cellpadding="0">
							<thead>
								<tr>
									<th class="two wide field">TIPO DE GADO</th>
									<th class="two wide field">ORIGEM</th>
									<th class="two wide field">CLASSIFICAÇÃO</th>
									<th class="two wide field">IDADE</th>
									<th class="two wide field">VALOR @</th>
									<th class="three wide field">TIPO BONIFICAÇÃO</th>
									<th class="two wide field">QTDE</th>
									<th class="one wide field">EXCLUIR</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$lista_descricao = (new CompraDescricao)->and('compra_descricao_compra', $data->compra_id)->listar(0); ?>
								<?php foreach ($lista_descricao as $descricao) : ?>
									<tr>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_gado_tipo[]" value="<?= $descricao->compra_descricao_gado_tipo ?>"><?= $descricao->compra_descricao_gado_tipo ?></td>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_origem[]" value="<?= $descricao->compra_descricao_origem ?>"><?= $descricao->compra_descricao_origem ?></td>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_classificacao[]" value="<?= $descricao->compra_descricao_classificacao ?>"><?= $descricao->compra_descricao_classificacao ?></td>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_idade[]" value="<?= $descricao->compra_descricao_idade ?>"><?= $descricao->compra_descricao_idade ?></td>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_valor_arroba[]" value="<?= $descricao->compra_descricao_valor_arroba ?>"><?= $descricao->compra_descricao_valor_arroba ?></td>
										<td class="three wide field"><input type="hidden" name="compra_descricao_tipo_bonificacao[]" value="<?= $descricao->compra_descricao_tipo_bonificacao ?>"><?= $descricao->compra_descricao_tipo_bonificacao ?></td>
										<td class="two wide field"> <input type="hidden" name="compra_descricao_quantidade[]" value="<?= $descricao->compra_descricao_quantidade ?>"><?= $descricao->compra_descricao_quantidade ?></td>
										<td class="one wide field"><button type="button" class="ui button red" onclick="remover_linha(this),calcular_gado()"> <i class="fas fa-times"></i></button></td>
									</tr>
								<?php endforeach ?>
							</tbody>
						</table>
						<div class="ui grid fields relaxed stackable margin_bottom_field grid_table">
							<div class="layout twelve wide field"></div>
							<div class="layout">
								<label> <?= Funcao::i18n($t_list, "compra_gado_total"); ?> </label>
								<input type="text" maxlength="11" class=" number text-right" name="compra_gado_total" value="<?= $data->compra_gado_total ?? '' ?>" readonly required>
							</div>
						</div>
					</div>


					<div class="ui segment green">
						<h1 class="ui header compra">DADOS TRANSPORTE / EMBARQUE ∕ ABATE</h1>
						<div class="ui grid fields relaxed stackable margin_bottom_field grid_table">
							<div class="layout six wide field">
								<label> VEICULO </label>
								<div id="veiculo" class="ui search selection dropdown">
									<input type="hidden" name="grid_transporte_veiculo" value="">
									<?php
									echo '<div class="default text">Selecione...</div>';
									?>
									<i class="dropdown icon"></i>
								</div>
							</div>
							<div class="layout six wide field">
								<label> MOTORISTA </label>
								<div id="motorista" class="ui search selection dropdown">
									<input type="hidden" name="grid_transporte_motorista" value="">
									<?php
									echo '<div class="default text">Selecione...</div>';
									?>
									<i class="dropdown icon"></i>
								</div>
							</div>
							<div class="layout three wide field">
								<label> <?= "QTDE ABRIGADA" ?> </label>
								<input type="text" maxlength="255" class="number" name="grid_transporte_qtd_abrigada" value="">
							</div>
							<div class="layout one wide field">
								<label> <?= "Adicionar" ?> </label>
								<button type="button" class="ui button green adicionar_transporte"><i class="fas fa-plus"></i></button>
							</div>
						</div>

						<table class="ui table tabela_transporte" border="1" cellspacing="0" cellpadding="0">
							<thead>
								<tr>
									<th>TIPO VEÍCULO / PLACA</th>
									<th>MOTORISTA</th>
									<th>QTDE ABRIGADA</th>
									<th class="one wide field">EXCLUIR</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$lista_transporte = (new CompraEmbarque)
									->and('compra_embarque_compromisso', $data->compra_id)
									->listar(2, 3);
								?>
								<?php foreach ($lista_transporte as $transporte) : ?>
									<tr>
										<td class="two wide field"> <input type="hidden" name="transporte_veiculo[]" value="<?= $transporte->compra_embarque_veiculo ?>">
											<?= $transporte->veiculo_tipo . "(" . $transporte->veiculo_quantidade_max_abrigada . ") | " . $transporte->veiculo_placa ?>
										</td>
										<td class="two wide field"> <input type="hidden" name="transporte_motorista[]" value="<?= $transporte->compra_embarque_motorista ?>">
											<?= $transporte->motorista_nome ?>
										</td>
										<td class="two wide field"> <input type="hidden" name="transporte_qtd_abrigada[]" value="<?= $transporte->compra_embarque_quantidade_abrigada ?>">
											<?= $transporte->compra_embarque_quantidade_abrigada ?>
										</td>
										<td class="one wide field"><button type="button" class="ui button red" onclick="remover_linha(this),calcular_transporte()"> <i class="fas fa-times"></i></button></td>
									</tr>
								<?php endforeach ?>
							</tbody>
						</table>
						<div class="ui grid fields relaxed stackable margin_bottom_field grid_table">
							<div class="eight wide field"></div>
							<div class="layout">
								<label> <?= Funcao::i18n($t_list, "compra_quantidade_veiculos"); ?> </label>
								<input type="text" maxlength="11" class=" number text-right" name="compra_quantidade_veiculos" value="<?= $data->compra_quantidade_veiculos ?? '' ?>" required readonly>
							</div>
							<div class="layout">
								<label> <?= Funcao::i18n($t_list, "compra_quantidade_total_abrigada"); ?> </label>
								<input type="text" maxlength="11" class=" number text-right" name="compra_quantidade_total_abrigada" value="<?= $data->compra_quantidade_total_abrigada ?? '' ?>" required readonly>
							</div>
						</div>
					</div>
					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>