<script>
	$(document).ready(function() {
		$('[name="compra_frigorifico"]').closest('div.layout').addClass('eight wide field');
		$('[name="compra_comprador"]').closest('div.layout').addClass('eight wide field');
		$('[name="compra_fazenda"]').closest('div.layout').addClass('twelve wide field');
		$('[name="compromisso_desconta_fundo_rural"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_gado_total"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_quantidade_veiculos"]').closest('div.layout').addClass(' four wide field');
		$('[name="compra_quantidade_total_abrigada"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_data"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_data_negociacao"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_data_abate"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_data_pagamento"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_data_embarque"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_endereco_mesmo"]').closest('div.layout').addClass('four wide field');
		$('[name="compra_endereco_embarque"]').closest('div.layout').addClass('twelve wide field');


		// AJAX OPTIONS
		$('#compra_frigorifico').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/frigorifico.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		$('#compra_comprador').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/comprador.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		$('#compra_fazenda').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/fazenda.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})

		$('#motorista').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/motorista.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})

		$('#veiculo').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/veiculo.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		// END AJAX OPTIONS
		sessionStorage.clear();

		$("#compra_fazenda").on('change', function() {
			$.post('<?= $url_site ?>/ajax_options/fundo_rural.ajax.php', {
					fazenda_id: $('[name="compra_fazenda"]').val()
				},
				function(retorno) {
					$('[name="compromisso_desconta_fundo_rural"]').val(retorno.pecuarista_desconto_fundo_rural);
					$('[name="compromisso_desconta_fundo_rural"]').change();
					$('[name="compra_endereco_mesmo"]').change();
				}
			);
		});

		$('[name="compra_endereco_mesmo"]').on('change', function() {
			if ($(this).val() == 'Sim') {
				$.post('<?= $url_site ?>/ajax_options/fundo_rural.ajax.php', {
						fazenda_id: $('[name="compra_fazenda"]').val()
					},
					function(retorno) {
						$('[name="compra_endereco_embarque"]').prop('readonly', true)
						$('[name="compra_endereco_embarque"]').val(retorno.fazenda_endereco + ' - ' + retorno.cidade_nome + ' - ' + retorno.cidade_uf + ' CEP: ' + retorno.cidade_cep);
					});
			} else {
				$('[name="compra_endereco_embarque"]').prop('readonly', false);
				$('[name="compra_endereco_embarque"]').val('');
			}

		});

		// campos required
		adicionarAsteriscos();
		calcular_transporte();
		calcular_gado();

		$('.adicionar_gado').on('click', function() {
			if (
				$('[name="grid_compra_descricao_gado_tipo"]').val() != '' &&
				$('[name="grid_compra_descricao_origem"]').val() != '' &&
				$('[name="grid_compra_descricao_classificacao"]').val() != '' &&
				$('[name="grid_compra_descricao_idade"]').val() != '' &&
				$('[name="grid_compra_descricao_valor_arroba"]').val() != '' &&
				$('[name="grid_compra_descricao_tipo_bonificacao"]').val() != '' &&
				$('[name="grid_compra_descricao_quantidade"]').val() != ''
			) {
				var add_linha_gado = '<tr>' +
					'	<td><input type="hidden" name="compra_descricao_gado_tipo[]" value="' + $('[name="grid_compra_descricao_gado_tipo"]').val() + '">' + $('[name="grid_compra_descricao_gado_tipo"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_origem[]" value="' + $('[name="grid_compra_descricao_origem"]').val() + '">' + $('[name="grid_compra_descricao_origem"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_classificacao[]" value="' + $('[name="grid_compra_descricao_classificacao"]').val() + '">' + $('[name="grid_compra_descricao_classificacao"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_idade[]" value="' + $('[name="grid_compra_descricao_idade"]').val() + '">' + $('[name="grid_compra_descricao_idade"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_valor_arroba[]" value="' + $('[name="grid_compra_descricao_valor_arroba"]').val() + '">' + $('[name="grid_compra_descricao_valor_arroba"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_tipo_bonificacao[]" value="' + $('[name="grid_compra_descricao_tipo_bonificacao"]').val() + '">' + $('[name="grid_compra_descricao_tipo_bonificacao"]').val() + '</td>' +
					'	<td><input type="hidden" name="compra_descricao_quantidade[]" value="' + $('[name="grid_compra_descricao_quantidade"]').val() + '">' + $('[name="grid_compra_descricao_quantidade"]').val() + '</td>' +
					'	<td><button type="button" class="ui button red" onclick="remover_linha(this),calcular_gado()"><i class="fas fa-times"></i></button> </td>' +
					'</tr>';
				$('.tabela_gado').find('tbody').append(add_linha_gado);
				calcular_gado();
			} else {
				alert('Preencha todos os campos')
			}

		});

		$('.adicionar_transporte').on('click', function() {
			if (
				$('[name="grid_transporte_veiculo"]').val() != '' &&
				$('[name="grid_transporte_motorista"]').val() != '' &&
				$('[name="grid_transporte_qtd_abrigada"]').val() != ''
			) {
				var add_linha_transporte = '<tr>' +
					'	<td><input type="hidden" name="transporte_veiculo[]" value="' + $('[name="grid_transporte_veiculo"]').val() + '">' + $('[name="grid_transporte_veiculo"]').siblings('.text').text() + '</td>' +
					'	<td><input type="hidden" name="transporte_motorista[]" value="' + $('[name="grid_transporte_motorista"]').val() + '">' + $('[name="grid_transporte_motorista"]').siblings('.text').text() + '</td>' +
					'	<td><input type="hidden" name="transporte_qtd_abrigada[]" value="' + $('[name="grid_transporte_qtd_abrigada"]').val() + '">' + $('[name="grid_transporte_qtd_abrigada"]').val() + '</td>' +
					'	<td><button type="button" class="ui button red" onclick="remover_linha(this),calcular_transporte()"><i class="fas fa-times"></i></button> </td>' +
					'</tr>';
				$('.tabela_transporte').find('tbody').append(add_linha_transporte);
				calcular_transporte();
			} else {
				alert('Preencha todos os campos')
			}
		});
	});

	$('button[name="send_form"]').on('click', function(event) {
		event.preventDefault();
		var form = $(this).closest('form');
		validation = validarFormulario($(this));

		if ($('[name="compra_gado_total"]').val() != $('[name="compra_quantidade_total_abrigada"]').val()) {
			$('#formError').modal('show');
			$('#formError').find('.mainModalContent').html('<div class="text-center">Quantidade abrigada diferente da quantidade de Cabeças!</div>');
			return false;
		} else if ($('[name="transporte_veiculo[0]"]').val() == 'undefined') {
			console.log('aqui');
			return false;
		} else {
			if (validation == 0) {
				var data = new FormData(form[0]);
				$.ajax({
					type: "POST",
					enctype: "multipart/form-data",
					url: "<?= $url_site ?>/modulos/compras/db.php",
					data: data,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 600000,
					success: function(data) {
						if (data.indexOf('sucesso') > -1) {
							var dados = JSON.parse(data);

							$('#modalFeedback').find('.modalContent').html('<div class="text-center">' + dados.msg_string + '</div>');
							$('#modalFeedback').modal('show');
							$("#btn-search").click();
							table.api().ajax.reload();
							closemodal();

						} else {
							$('#formError').modal('show');
							if (data.indexOf('Fatal error') > -1) {
								$('#formError').find('.mainModalContent').html('<div class="text-center">Informe o desenvolvedor <br> Erro 0001</div>');
							} else if (data == '') {
								$('#formError').find('.mainModalContent').html('<div class="text-center">' +
									'Erro desconhecido ' +
									'</div>');
							} else {
								var dados = JSON.parse(data);
								$('#formError').find('.mainModalContent').html('<div class="text-center">' + JSON.stringify(dados.error_msg) + '</div>');
							}
						}
					},
					error: function(e) {
						$('#formError').modal('show');
						$('#formError').find('.mainModalContent').html('<div class="text-center">Requisição não foi executada!</div>');
						console.log("ERROR : ", e);
					}
				});

			} else {
				$('body').toast({
					class: 'error',
					position: 'bottom center',
					showIcon: 'exclamation',
					message: 'Um ou mais campos obrigatórios não foram preenchidos corretamente <br> Revise os campos!'
				});
			}
		}
	});

	function calcular_gado() {
		var linhas = $('.tabela_gado').find('tbody').find('tr');
		var total = 0;
		$.each(linhas, function(indexInArray, valueOfElement) {
			var qtd = parseInt($(this).find('td:eq(-2)').text());
			total = total + qtd;
		});
		$('[name="compra_gado_total"]').val(total);
	}

	function calcular_transporte() {
		var linhas = $('.tabela_transporte').find('tbody').find('tr');
		var total = 0;
		$.each(linhas, function(indexInArray, valueOfElement) {
			var qtd = parseInt($(this).find('td:eq(-2)').text());
			total = total + qtd;
		});
		$('[name="compra_quantidade_total_abrigada"]').val(total);
		$('[name="compra_quantidade_veiculos"]').val(linhas.length);
	}
</script>