<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {
				'url': '<?= $url_site . 'modulos/compras/home.ajax.php'; ?>'
			},
			'columns': [{
					title: '<?= Funcao::i18n($t_list, "compra_id"); ?>',
					data: 'compra_id'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_nome"); ?>',
					data: 'frigorifico_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "comprador_nome"); ?>',
					data: 'comprador_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_nome"); ?>',
					data: 'fazenda_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compromisso_desconta_fundo_rural"); ?>',
					data: 'compromisso_desconta_fundo_rural'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_gado_total"); ?>',
					data: 'compra_gado_total'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_quantidade_veiculos"); ?>',
					data: 'compra_quantidade_veiculos'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_quantidade_total_abrigada"); ?>',
					data: 'compra_quantidade_total_abrigada'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_data_negociacao"); ?>',
					data: 'compra_data_negociacao'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_data_abate"); ?>',
					data: 'compra_data_abate'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_data_pagamento"); ?>',
					data: 'compra_data_pagamento'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_data_embarque"); ?>',
					data: 'compra_data_embarque'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_endereco_mesmo"); ?>',
					data: 'compra_endereco_mesmo'
				},
				{
					title: '<?= Funcao::i18n($t_list, "compra_endereco_embarque"); ?>',
					data: 'compra_endereco_embarque'
				},
				{
					title: '<?= Funcao::i18n($act_list, "action"); ?>',
					className: 'text-center',
					data: null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.compra_id;
						return '<div class="ui buttons">' +
							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
							'<i class="eye outline icon "></i>' +
							'</button>' +
							'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
							'<i class="edit alternate icon "></i>' +
							'</button>' +
							'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" onclick="modalExcluir(this)" data-id="' + _id + '">' +
							'<i class=\'trash alternate icon\'></i>' +
							'</button>' +
							'</div>' +
							'<div class="ui buttons with margin top">' +
							'<a  target="_blank" href="<?= $url_site ?>modulos/compras/compromisso.php?procotolo=' + _id + '" class="mini ui basic icon button blue" data-tooltip="Compromisso" data-id="' + _id + '" data-inverted=""  data-action="compromisso"  data-position="top left">' +
							'<i class="handshake icon "></i>' +
							'</a>' +
							'<a  target="_blank" href="<?= $url_site ?>modulos/compras/aviso_compra.php?procotolo=' + _id + '" class="mini ui basic icon button blue" data-tooltip="Aviso de Compra" data-content="Aviso de Compra"  data-inverted=""  data-action="aviso_compra"  data-position="top center">' +
							'<i class="exclamation icon "></i>' +
							'</a>' +
							'<button class="mini ui basic icon button blue" data-tooltip="Anexos" data-content="Aviso de Compra" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="anexo"  data-position="top center">' +
							'<i class="linkify icon "></i>' +
							'</button>' +
							'</div>'
					}
				}
			],
			"columnDefs": [{
					responsivePriority: 1,
					targets: 0
				},
				{
					responsivePriority: 1,
					targets: 1
				},
				{
					responsivePriority: 1,
					width: '60px',
					targets: -1
				}
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?= $url_site ?>datatables.ptbr.json"
			},
			"order": [
				[0, "asc"]
			],
			"drawCallback": function() {
				$(".excluir").popup({
					on: "click"
				});
			}
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
	});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			autofocus: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				switch (action) {
					case "new":
						$("#btnEnviar").show();
						mainModalTitle('Compra : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
						requisicaoPOST({
							'url': '<?= $url_site ?>modulos/compras/form.php',
							'campos': {
								id: id,
								action: action
							},
							'conteudo': '#mainModalContent',
							'callback': afterCompra,
							'callbackparams': 'fullscreen'
						});
						break;
					case "edit":
						$("#btnEnviar").show();
						mainModalTitle('Compra : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
						requisicaoPOST({
							'url': '<?= $url_site ?>modulos/compras/form.php',
							'campos': {
								id: id,
								action: action
							},
							'conteudo': '#mainModalContent',
							'callback': afterCompra,
							'callbackparams': 'fullscreen'
						});
						break;

					case "show":
						mainModalTitle('Compra : <?= Funcao::i18n($act_list, "show"); ?>');
						requisicaoPOST({
							'url': '<?= $url_site ?>modulos/compras/detail.php',
							'campos': {
								id: id,
								action: action
							},
							'conteudo': '#mainModalContent',
							'callback': afterCompra,
							'callbackparams': 'fullscreen'
						});
						break;
					case "anexo":
						mainModalTitle('Compra : ANEXOS');
						requisicaoPOST({
							'url': '<?= $url_site ?>modulos/compras/anexos.php',
							'campos': {
								id: id,
								action: action
							},
							'conteudo': '#mainModalContent',
							'callback': afterCompra,
							'callbackparams': 'fullscreen'
						});
						break;
					default:
						break;
				}
				if (action == "new" || action == "edit") {

				} else {

				}
			}
		}).modal('show');
	}

	function afterCompra(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}


	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post("<?= $url_site ?>modulos/compras/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso', 'Registro excluido com sucesso!');
			} else {
				toast('erro', 'Erro ao excluir, ação não permitida!');
			}
		});
	}
</script>