<?php require_once("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="frigorifico_id" value="<?= $data->frigorifico_id ?? ''; ?>">

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_principal"); ?> </label>
							<select name="frigorifico_principal" class=" " required>
								<option value="">Selecione...</option>
								<option value="Não" <?= ($data->frigorifico_principal ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
								<option value="Sim" <?= ($data->frigorifico_principal ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
							</select>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_nome"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_nome" value="<?= $data->frigorifico_nome ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_cnpj"); ?> </label>
							<input type="text" maxlength="255" class=" cnpj" name="frigorifico_cnpj" value="<?= $data->frigorifico_cnpj ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_inscricao"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_inscricao" value="<?= $data->frigorifico_inscricao ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_tare"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_tare" value="<?= $data->frigorifico_tare ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_classificacao"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_classificacao" value="<?= $data->frigorifico_classificacao ?? '' ?>" required>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_sif"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_sif" value="<?= $data->frigorifico_sif ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_endereco"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_endereco" value="<?= $data->frigorifico_endereco ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_bairro"); ?> </label>
							<input type="text" maxlength="255" class=" " name="frigorifico_bairro" value="<?= $data->frigorifico_bairro ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_cep"); ?> </label>
							<input type="text" maxlength="255" class=" cep" name="frigorifico_cep" value="<?= $data->frigorifico_cep ?? '' ?>" required>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "frigorifico_cidade"); ?> </label>
							<div id="frigorifico_cidade" class="ui search selection dropdown">
								<input type="hidden" name="frigorifico_cidade" value="<?= $data->frigorifico_cidade ?>" required>
								<?php
								if ($data->frigorifico_cidade != "") {
									echo '<div class="text">' . $data->frigorifico_cidade . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

					</div>
					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>