<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {
				'url': '<?= $url_site . 'modulos/frigorifico/home.ajax.php'; ?>'
			},
			'columns': [{
					title: '<?= Funcao::i18n($t_list, "frigorifico_id"); ?>',
					data: 'frigorifico_id'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_principal"); ?>',
					data: 'frigorifico_principal'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_nome"); ?>',
					data: 'frigorifico_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_cnpj"); ?>',
					data: 'frigorifico_cnpj'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_inscricao"); ?>',
					data: 'frigorifico_inscricao'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_tare"); ?>',
					data: 'frigorifico_tare'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_classificacao"); ?>',
					data: 'frigorifico_classificacao'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_sif"); ?>',
					data: 'frigorifico_sif'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_endereco"); ?>',
					data: 'frigorifico_endereco'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_bairro"); ?>',
					data: 'frigorifico_bairro'
				},
				{
					title: '<?= Funcao::i18n($t_list, "frigorifico_cep"); ?>',
					data: 'frigorifico_cep'
				},
				{
					title: '<?= Funcao::i18n($t_list, "cidade_uf"); ?>',
					data: 'cidade_uf'
				},
				{
					title: '<?= Funcao::i18n($t_list, "cidade_nome"); ?>',
					data: 'cidade_nome'
				},
				{
					title: '<?= Funcao::i18n($act_list, "action"); ?>',
					className: 'text-center',
					data: null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.frigorifico_id;
						return '<div class="ui buttons">' +

							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
							'<i class="eye outline icon "></i>' +
							'</button>' +
							'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
							'<i class="edit alternate icon "></i>' +
							'</button>' +
							'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" onclick="modalExcluir(this)" data-id="' + _id + '">' +
							'<i class=\'trash alternate icon\'></i>' +
							'</button>' +
							'</div>'
					}
				}
			],
			"columnDefs": [{
					responsivePriority: 1,
					targets: 0
				},
				{
					responsivePriority: 1,
					targets: 1
				},
				{
					responsivePriority: 1,
					targets: 6
				},
				{
					responsivePriority: 1,
					targets: -3
				},
				{
					responsivePriority: 1,
					targets: -2
				},
				{
					responsivePriority: 1,
					width: '60px',
					targets: -1
				}
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?= $url_site ?>datatables.ptbr.json"
			},
			"order": [
				[1, "desc"]
			],
			"drawCallback": function() {
				$(".excluir").popup({
					on: "click"
				});
			}
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
	});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == "new" || action == "edit") {
					$("#btnEnviar").show();
					mainModalTitle('Frigorifico : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/frigorifico/form.php',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterFrigorifico,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('Frigorifico : <?= Funcao::i18n($act_list, "show"); ?>');
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/frigorifico/detail.php',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterFrigorifico,
						'callbackparams': 'big'
					});
				}
			}
		}).modal('show');
	}

	function afterFrigorifico(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}

	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post("<?= $url_site ?>modulos/frigorifico/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso', 'Registro excluido com sucesso!');
			} else {
				toast('erro', 'Erro ao excluir, ação não permitida!');
			}
		});
	}
</script>