<?php require_once("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="pecuarista_conta_id" value="<?= $data->pecuarista_conta_id ?? ''; ?>">

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_pecuarista"); ?> </label>
							<div id="pecuarista_conta_pecuarista" class="ui search selection dropdown">
								<input type="hidden" name="pecuarista_conta_pecuarista" value="<?= $data->pecuarista_conta_pecuarista ?>" required>
								<?php
								if ($data->pecuarista_conta_pecuarista != "") {
									echo '<div class="text">' . $data->pecuarista_conta_pecuarista . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_preferencial"); ?> </label>
							<select name="pecuarista_conta_preferencial" class=" " required>
								<option value="">Selecione...</option>
								<option value="Não" <?= ($data->pecuarista_conta_preferencial ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
								<option value="Sim" <?= ($data->pecuarista_conta_preferencial ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_conjunta"); ?> </label>
							<select name="pecuarista_conta_conjunta" class=" " required>
								<option value="">Selecione...</option>
								<option value="Não" <?= ($data->pecuarista_conta_conjunta ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
								<option value="Sim" <?= ($data->pecuarista_conta_conjunta ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_tipo_conta"); ?> </label>
							<select name="pecuarista_conta_tipo_conta" class=" " required>
								<option value="">Selecione...</option>
								<option value="Corrente" <?= ($data->pecuarista_conta_tipo_conta ?? '') == 'Corrente' ? 'selected' : '' ?>>Corrente</option>
								<option value="Poupança" <?= ($data->pecuarista_conta_tipo_conta ?? '') == 'Poupança' ? 'selected' : '' ?>>Poupança</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_banco"); ?> </label>
							<div id="pecuarista_conta_banco" class="ui search selection dropdown">
								<input type="hidden" name="pecuarista_conta_banco" value="<?= $data->pecuarista_conta_banco ?>" required>
								<?php
								if ($data->pecuarista_conta_banco != "") {
									echo '<div class="text">' . $data->pecuarista_conta_banco . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_agencia"); ?> </label>
							<input type="text" maxlength="255" class=" number" name="pecuarista_conta_agencia" value="<?= $data->pecuarista_conta_agencia ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_agencia_digito"); ?> </label>
							<input type="text" maxlength="255" class=" " name="pecuarista_conta_agencia_digito" value="<?= $data->pecuarista_conta_agencia_digito ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_conta"); ?> </label>
							<input type="text" maxlength="255" class="number " name="pecuarista_conta_conta" value="<?= $data->pecuarista_conta_conta ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_conta_digito"); ?> </label>
							<input type="text" maxlength="255" class=" " name="pecuarista_conta_conta_digito" value="<?= $data->pecuarista_conta_conta_digito ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_pix_tipo"); ?> </label>
							<select name="pecuarista_conta_pix_tipo" class=" ">
								<option value="">Selecione...</option>
								<option value="CPF" <?= ($data->pecuarista_conta_pix_tipo ?? '') == 'CPF' ? 'selected' : '' ?>>CPF</option>
								<option value="CNPJ" <?= ($data->pecuarista_conta_pix_tipo ?? '') == 'CNPJ' ? 'selected' : '' ?>>CNPJ</option>
								<option value="E-mail" <?= ($data->pecuarista_conta_pix_tipo ?? '') == 'E-mail' ? 'selected' : '' ?>>E-mail</option>
								<option value="Telefone" <?= ($data->pecuarista_conta_pix_tipo ?? '') == 'Telefone' ? 'selected' : '' ?>>Telefone</option>
								<option value="Chave Aleatória" <?= ($data->pecuarista_conta_pix_tipo ?? '') == 'Chave Aleatória' ? 'selected' : '' ?>>Chave Aleatória</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_conta_pix_chave"); ?> </label>
							<input type="text" maxlength="255" class=" " name="pecuarista_conta_pix_chave" value="<?= $data->pecuarista_conta_pix_chave ?? '' ?>">
						</div>


					</div>
					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>