<script>
	$(document).ready(function() {
		$('[name="pecuarista_conta_pecuarista"]').closest('div.layout').addClass('eight wide field').remove();
		$('[name="pecuarista_conta_preferencial"]').closest('div.layout').addClass('five wide field');
		$('[name="pecuarista_conta_conjunta"]').closest('div.layout').addClass('five wide field');
		$('[name="pecuarista_conta_tipo_conta"]').closest('div.layout').addClass('six wide field');
		$('[name="pecuarista_conta_banco"]').closest('div.layout').addClass('sixteen wide field');
		$('[name="pecuarista_conta_agencia"]').closest('div.layout').addClass('five wide field');
		$('[name="pecuarista_conta_agencia_digito"]').closest('div.layout').addClass('three wide field');
		$('[name="pecuarista_conta_conta"]').closest('div.layout').addClass('five wide field');
		$('[name="pecuarista_conta_conta_digito"]').closest('div.layout').addClass('three wide field');
		$('[name="pecuarista_conta_pix_tipo"]').closest('div.layout').addClass('six wide field');
		$('[name="pecuarista_conta_pix_chave"]').closest('div.layout').addClass('ten wide field');
		// AJAX OPTIONS
		$('#pecuarista_conta_pecuarista').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/pecuarista.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		$('#pecuarista_conta_banco').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/banco.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		// END AJAX OPTIONS
		sessionStorage.clear();

		// campos required
		adicionarAsteriscos();
	});

	$('button[name="send_form"]').on('click', function(event) {
		event.preventDefault();
		var form = $(this).closest('form');
		validation = validarFormulario($(this));
		if (validation == 0) {
			var data = new FormData(form[0]);
			data.append('pecuarista_conta_pecuarista', '<?= $_GET["fk"] ?>');
			$.ajax({
				type: "POST",
				enctype: "multipart/form-data",
				url: "<?= $url_site ?>/modulos/pecuarista/conta/db.php",
				data: data,
				processData: false,
				contentType: false,
				cache: false,
				timeout: 600000,
				success: function(data) {
					if (data.indexOf('sucesso') > -1) {
						var dados = JSON.parse(data);
						$('#modalFeedback').modal('show');
						$('#modalFeedback').find('.modalContent').html('<div class="text-center">' + dados.msg_string + '</div>');
						$("#btn-search").click();
						$("#btnEnviar").hide();
						table.api().ajax.reload();
					} else {
						$('#formError').modal('show');
						if (data.indexOf('Fatal error') > -1) {
							$('#formError').find('.mainModalContent').html('<div class="text-center">Informe o desenvolvedor <br> Erro 0001</div>');
						} else if (data == '') {
							$('#formError').find('.mainModalContent').html('<div class="text-center">' +
								'Erro desconhecido ' +
								'</div>');
						} else {
							var dados = JSON.parse(data);
							$('#formError').find('.mainModalContent').html('<div class="text-center">' + JSON.stringify(dados.error_msg) + '</div>');
						}
					}
				},
				error: function(e) {
					$('#formError').modal('show');
					$('#formError').find('.mainModalContent').html('<div class="text-center">Requisição não foi executada!</div>');
					console.log("ERROR : ", e);
				}
			});
		} else {
			$('body').toast({
				class: 'error',
				position: 'bottom center',
				showIcon: 'exclamation',
				message: 'Um ou mais campos obrigatórios não foram preenchidos corretamente <br> Revise os campos!'
			});
		}
	});
</script>