<script>
	var table;


	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			initComplete: function(settings, json) {
				$.each($('tr'), function(indexInArray, valueOfElement) {
					let preferencial = $(this).find('td:eq(1)');
					if (preferencial.text() == 'Sim') {
						$(this).addClass('green');
					}
				});
			},
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {
				'url': '<?= $url_site . 'modulos/pecuarista/conta/home.ajax.php?fk=' . $_POST["fk"]; ?>'
			},
			'columns': [{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_id"); ?>',
					data: 'pecuarista_conta_id'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_preferencial"); ?>',
					data: 'pecuarista_conta_preferencial'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_conjunta"); ?>',
					data: 'pecuarista_conta_conjunta'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_tipo_conta"); ?>',
					data: 'pecuarista_conta_tipo_conta'
				},
				{
					title: '<?= Funcao::i18n($t_list, "banco_numero"); ?>',
					data: 'banco_numero'
				},
				{
					title: '<?= Funcao::i18n($t_list, "banco_nome"); ?>',
					data: 'banco_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_agencia"); ?>',
					data: 'pecuarista_conta_agencia'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_agencia_digito"); ?>',
					data: 'pecuarista_conta_agencia_digito'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_conta"); ?>',
					data: 'pecuarista_conta_conta'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_conta_digito"); ?>',
					data: 'pecuarista_conta_conta_digito'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_pix_tipo"); ?>',
					data: 'pecuarista_conta_pix_tipo'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_conta_pix_chave"); ?>',
					data: 'pecuarista_conta_pix_chave'
				},
				{
					title: '<?= Funcao::i18n($act_list, "action"); ?>',
					className: 'text-center',
					data: null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.pecuarista_conta_id;
						return '<div class="ui buttons">' +

							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
							'<i class="eye outline icon "></i>' +
							'</button>' +
							'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
							'<i class="edit alternate icon "></i>' +
							'</button>' +
							'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" onclick="modalExcluir(this)" data-id="' + _id + '">' +
							'<i class=\'trash alternate icon\'></i>' +
							'</button>' +
							'</div>'
					}
				}
			],
			"columnDefs": [{
					responsivePriority: 1,
					targets: 0
				},
				{
					responsivePriority: 1,
					targets: 1
				},
				{
					responsivePriority: 1,
					width: '60px',
					targets: -1
				}
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?= $url_site ?>datatables.ptbr.json"
			},
			"order": [
				[0, "asc"]
			],
			"drawCallback": function() {
				$(".excluir").popup({
					on: "click"
				});
			}
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
	});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == "new" || action == "edit") {
					$("#btnEnviar").show();
					mainModalTitle('PecuaristaConta : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/conta/form.php?fk=<?= $_POST["fk"] ?>',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterPecuaristaConta,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('PecuaristaConta : <?= Funcao::i18n($act_list, "show"); ?>');
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/conta/detail.php?fk=<?= $_POST["fk"] ?>',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterPecuaristaConta,
						'callbackparams': 'big'
					});
				}
			}
		}).modal('show');
	}

	function afterPecuaristaConta(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}

	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post("<?= $url_site ?>modulos/pecuarista/conta/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso', 'Registro excluido com sucesso!');
			} else {
				toast('erro', 'Erro ao excluir, ação não permitida!');
			}
		});
	}
</script>