<?php require_once("form_custom_header.php"); ?>
<div class="ui segment attached fitted noborder clearing margin_bottom_reg">
	<div class="ui mini labeled button right floated">
		<div class="ui mini black button"> Registro
		</div>
		<a class="ui mini basic black  label">
			<?= $data->pecuarista_id; ?>
		</a>
	</div>
</div>

<?php
ob_start();
$action = "edit";
include "form.php";
$dados = ob_get_contents();
ob_end_clean();
echo Regex::converterFormulario($dados);
?>

<div class="ui segment green">
	<h1 class="ui header">Dados Bancários</h1>
	<table class="ui unstackable celed table" style="width:99%">
		<thead>
			<tr>
				<th>Conta Preferencial</th>
				<th>Conta Conjunta</th>
				<th>Tipo de Conta</th>
				<th>Banco</th>
				<th>Agencia</th>
				<th>Conta</th>
				<th>Tipo de Chave Pix</th>
				<th>Chave Pix</th>
			</tr>
		</thead>
		<tbody>
			<?php
			$contas = (new PecuaristaConta)
				->and("pecuarista_conta_pecuarista", $data->pecuarista_id)
				->orderBy("(pecuarista_conta_preferencial = 'SIM') DESC, pecuarista_conta_preferencial")
				->listar();
			foreach ($contas as $key => $conta) {
			?>
				<tr class="<?= ($conta->pecuarista_conta_preferencial == 'Sim' ? 'green' : '') ?>">
					<td><?= $conta->pecuarista_conta_preferencial ?> </td>
					<td><?= $conta->pecuarista_conta_conjunta ?> </td>
					<td><?= $conta->pecuarista_conta_tipo_conta ?> </td>
					<td><?= $conta->banco_numero . ' - ' . $conta->banco_nome ?></td>
					<td><?= $conta->pecuarista_conta_agencia . '-' . $conta->pecuarista_conta_agencia_digito ?> </td>
					<td><?= $conta->pecuarista_conta_conta . '-' . $conta->pecuarista_conta_conta_digito ?></td>
					<td><?= $conta->pecuarista_conta_pix_tipo ?></td>
					<td><?= $conta->pecuarista_conta_pix_chave ?></td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
</div>
<div class="ui two column equal height grid stackable">
	<div class="column  ">
		<div class="ui segment blue">
			<h1 class="ui header">Telefones</h1>
			<table class="ui unstackable celed table" style="width:99%">
				<thead>
					<tr>
						<th class="two wide column">Tipo</th>
						<th class="fourten wide column">Telefone</th>
					</tr>
				</thead>
				<tbody>
					<?php
					$contatos = (new PecuaristaTelefone)
						->and("pecuarista_telefone_pecuarista", $data->pecuarista_id)
						->orderBy("(contato_tipo_nome = 'PRINCIPAL') DESC, contato_tipo_nome")
						->listar();
					foreach ($contatos as $key => $contato) {
					?>
						<tr class="<?= ($contato->contato_tipo_nome == 'PRINCIPAL' ? 'blue' : '') ?>">
							<td><?= $contato->contato_tipo_nome ?> </td>
							<td><?= $contato->pecuarista_telefone_numero ?> </td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
	<div class="column  ">
		<div class="ui segment yellow ">
			<h1 class="ui header">E-mails</h1>
			<table class="ui unstackable celed table" style="width:99%">
				<thead>
					<tr>
						<th class="two wide column">Tipo</th>
						<th class="fourten wide column">E-mail</th>
					</tr>
				</thead>
				<tbody>
					<?php
					$emails = (new PecuaristaEmail)
						->and("pecuarista_email_pecuarista", $data->pecuarista_id)
						->orderBy("(pecuarista_email_tipo = 'Principal') DESC, pecuarista_email_tipo")
						->listar();
					foreach ($emails as $key => $email) {
					?>
						<tr class="<?= ($email->pecuarista_email_tipo == 'Principal' ? 'yellow' : '') ?>">
							<td><?= $email->pecuarista_email_tipo ?> </td>
							<td><?= $email->pecuarista_email_endereco ?> </td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
</div>


<?php require_once("form_custom_footer.php"); ?>