<?php require_once("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<legend>DADOS DA FAZENDA</legend>
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="fazenda_id" value="<?= $data->fazenda_id ?? ''; ?>">

						<div class="layout ">
							<input type="hidden" name="fazenda_pecuarista" value="<?= $data->fazenda_pecuarista ?>" required>
							<label> <?= Funcao::i18n($t_list, "fazenda_pecuarista"); ?> </label>
							<div id="fazenda_pecuarista" class="ui search selection dropdown">
								<?php
								if ($data->fazenda_pecuarista != "") {
									echo '<div class="text">' . $data->fazenda_pecuarista . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_nome"); ?> </label>
							<input type="text" maxlength="255" class=" " name="fazenda_nome" value="<?= $data->fazenda_nome ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_principal"); ?> </label>
							<select name="fazenda_principal" class=" " required>
								<option value="">Selecione...</option>
								<option value="Não" <?= ($data->fazenda_principal ?? '') == 'Não' ? 'selected' : '' ?>>Não</option>
								<option value="Sim" <?= ($data->fazenda_principal ?? '') == 'Sim' ? 'selected' : '' ?>>Sim</option>
							</select>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_telefone"); ?> </label>
							<input type="text" maxlength="255" class=" phone" name="fazenda_telefone" value="<?= $data->fazenda_telefone ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_inscricao"); ?> </label>
							<input type="text" maxlength="255" class=" inscricao" name="fazenda_inscricao" value="<?= $data->fazenda_inscricao ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_endereco"); ?> </label>
							<input type="text" maxlength="255" class=" " name="fazenda_endereco" value="<?= $data->fazenda_endereco ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_cidade"); ?> </label>
							<div id="fazenda_cidade" class="ui search selection dropdown">
								<input type="hidden" name="fazenda_cidade" value="<?= $data->fazenda_cidade ?>" required>
								<?php
								if ($data->fazenda_cidade != "") {
									echo '<div class="text">' . $data->cidade_nome . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_car_numero"); ?> </label>
							<input type="text" maxlength="255" class=" " name="fazenda_car_numero" value="<?= $data->fazenda_car_numero ?? '' ?>" required>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_car"); ?>
								<?php
								if ($action == "edit") {
									echo (!is_null($data->fazenda_car)) ? ": <a target='_blank' href='{$url_site}documento.php?id={$data->fazenda_car}'>Abrir arquivo atual</a>" : ' | Sem arquivo';
								}
								?></label>
							<div class="ui file action input ">
								<input id="fazenda_car" name="fazenda_car" type="file">
								<label for="fazenda_car" class="ui blue button">
									<i class="file icon"></i>
									Escolha um arquivo
								</label>
							</div>
						</div>
					</div>


					<br>
					<legend>DADOS DO GERENTE</legend>
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_gerente_nome"); ?> </label>
							<input type="text" maxlength="255" class=" " name="fazenda_gerente_nome" value="<?= $data->fazenda_gerente_nome ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_gerente_telefone"); ?> </label>
							<input type="text" maxlength="255" class=" phone" name="fazenda_gerente_telefone" value="<?= $data->fazenda_gerente_telefone ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "fazenda_gerente_email"); ?> </label>
							<input type="email" maxlength="255" class=" " name="fazenda_gerente_email" value="<?= $data->fazenda_gerente_email ?? '' ?>">
						</div>
					</div>

					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>