<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			initComplete: function(settings, json) {
				$.each($('tr'), function(indexInArray, valueOfElement) {
					let preferencial = $(this).find('td:eq(1)');
					if (preferencial.text() == 'Sim') {
						$(this).addClass('green');
					}
				});
			},
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {
				'url': '<?= $url_site . 'modulos/pecuarista/fazenda/home.ajax.php?fk=' . $_POST["fk"]; ?>'
			},
			'columns': [{
					title: '<?= Funcao::i18n($t_list, "fazenda_id"); ?>',
					data: 'fazenda_id'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_principal"); ?>',
					data: 'fazenda_principal'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_nome"); ?>',
					data: 'fazenda_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_inscricao"); ?>',
					data: 'fazenda_inscricao'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_endereco"); ?>',
					data: 'fazenda_endereco'
				},
				{
					title: '<?= Funcao::i18n($t_list, "cidade_nome"); ?>',
					data: 'cidade_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_car"); ?>',
					data: 'fazenda_car'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_telefone"); ?>',
					data: 'fazenda_telefone'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_gerente_nome"); ?>',
					data: 'fazenda_gerente_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_gerente_telefone"); ?>',
					data: 'fazenda_gerente_telefone'
				},
				{
					title: '<?= Funcao::i18n($t_list, "fazenda_gerente_email"); ?>',
					data: 'fazenda_gerente_email'
				},
				{
					title: '<?= Funcao::i18n($act_list, "action"); ?>',
					className: 'text-center',
					data: null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.fazenda_id;
						return '<div class="ui buttons">' +

							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
							'<i class="eye outline icon "></i>' +
							'</button>' +
							'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
							'<i class="edit alternate icon "></i>' +
							'</button>' +
							'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" onclick="modalExcluir(this)" data-id="' + _id + '">' +
							'<i class=\'trash alternate icon\'></i>' +
							'</button>' +
							'</div>'
					}
				}
			],
			"columnDefs": [{
					responsivePriority: 1,
					targets: 0
				},
				{
					responsivePriority: 1,
					targets: 1
				},
				{
					responsivePriority: 1,
					width: '60px',
					targets: -1
				}
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?= $url_site ?>datatables.ptbr.json"
			},
			"order": [
				[1, "desc"]
			],
			"drawCallback": function() {
				$(".excluir").popup({
					on: "click"
				});
			}
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
	});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == "new" || action == "edit") {
					$("#btnEnviar").show();
					mainModalTitle('Fazenda : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/fazenda/form.php?fk=<?= $_POST["fk"] ?>',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterFazenda,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('Fazenda : <?= Funcao::i18n($act_list, "show"); ?>');
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/fazenda/detail.php?fk=<?= $_POST["fk"] ?>',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterFazenda,
						'callbackparams': 'big'
					});
				}
			}
		}).modal('show');
	}

	function afterFazenda(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}


	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post("<?= $url_site ?>modulos/pecuarista/fazenda/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso', 'Registro excluido com sucesso!');
			} else {
				toast('erro', 'Erro ao excluir, ação não permitida!');
			}
		});
	}
</script>