<?php require_once("form_custom_header.php"); ?>
<div class="bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="pecuarista_id" value="<?= $data->pecuarista_id ?? ''; ?>">

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_nome"); ?> </label>
							<input type="text" maxlength="255" class=" " name="pecuarista_nome" value="<?= $data->pecuarista_nome ?? '' ?>" required>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_cpf"); ?> </label>
							<input type="text" maxlength="255" class=" cpf" name="pecuarista_cpf" value="<?= $data->pecuarista_cpf ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_cnpj"); ?> </label>
							<input type="text" maxlength="255" class=" cnpj" name="pecuarista_cnpj" value="<?= $data->pecuarista_cnpj ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_rg"); ?> </label>
							<input type="text" maxlength="255" class=" " name="pecuarista_rg" value="<?= $data->pecuarista_rg ?? '' ?>">
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_cidade"); ?> </label>
							<div id="pecuarista_cidade" class="ui search selection dropdown">
								<input type="hidden" name="pecuarista_cidade" value="<?= $data->pecuarista_cidade ?>">
								<?php
								if ($data->pecuarista_cidade != "") {
									echo '<div class="text">' . $data->cidade_uf . ' - ' . $data->cidade_nome . '</div>';
								} else {
									echo '<div class="default text">Selecione...</div>';
								}
								?>
								<i class="dropdown icon"></i>
							</div>
						</div>

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_desconto_fundo_rural"); ?> </label>
							<select name="pecuarista_desconto_fundo_rural" class=" " required>
								<option value="">Selecione...</option>
								<option value="Não" <?= ($data->pecuarista_desconto_fundo_rural) == 'Não' ? 'selected' : '' ?>>Não</option>
								<option value="Sim" <?= ($data->pecuarista_desconto_fundo_rural) == 'Sim' ? 'selected' : '' ?>>Sim</option>
							</select>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "pecuarista_deconto_fundo_rural_anexo"); ?>
								<?php
								if ($action == "edit") {
									echo (!is_null($data->pecuarista_deconto_fundo_rural_anexo)) ? ": <a target='_blank' href='{$url_site}documento.php?id={$data->pecuarista_deconto_fundo_rural_anexo}'>Abrir arquivo atual</a>" : ' | Sem arquivo';
								}
								?></label>
							<div class="ui file action input ">
								<input id="pecuarista_deconto_fundo_rural_anexo" name="pecuarista_deconto_fundo_rural_anexo" type="file">
								<label for="pecuarista_deconto_fundo_rural_anexo" class="ui blue button">
									<i class="file icon"></i>
									Escolha um arquivo
								</label>
							</div>
						</div>
					</div>
					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>