<script>
	$(document).ready(function() {
		$('[name="pecuarista_nome"]').closest('div.layout').addClass('sixteen wide field');
		$('[name="pecuarista_cpf"]').closest('div.layout').addClass('six wide field');
		$('[name="pecuarista_cnpj"]').closest('div.layout').addClass('six wide field');
		$('[name="pecuarista_rg"]').closest('div.layout').addClass('four wide field');
		$('[name="pecuarista_cidade"]').closest('div.layout').addClass('eight wide field');
		$('[name="pecuarista_desconto_fundo_rural"]').closest('div.layout').addClass('eight wide field');
		$('[name="pecuarista_deconto_fundo_rural_anexo"]').closest('div.layout').addClass('sixteen wide field').hide();



		$('[name="pecuarista_desconto_fundo_rural"]').on('change', function() {
			if ($(this).val() == "Não") {
				$('[name="pecuarista_deconto_fundo_rural_anexo"]').closest('div.layout').fadeIn();
			} else {
				$('[name="pecuarista_deconto_fundo_rural_anexo"]').closest('div.layout').fadeOut();
			}
		}).change();
		// AJAX OPTIONS
		$('#pecuarista_cidade').dropdown({
			apiSettings: {
				url: '<?= $url_site ?>/ajax_options/cidade.ajax.php?filtro={query}'
			},
			saveRemoteData: false
		})
		// END AJAX OPTIONS
		sessionStorage.clear();
		$('#pecuarista_cidade').change();

		// campos required
		adicionarAsteriscos();

		if ($('div[name="pecuarista_desconto_fundo_rural"]').text() == "Não") {
			$('div[name="pecuarista_deconto_fundo_rural_anexo"]').closest('div.layout').show();
			$('div[name="pecuarista_desconto_fundo_rural"]').closest('div.layout').next('.layout').show();
		} else {
			$('div[name="pecuarista_deconto_fundo_rural_anexo"]').closest('div.layout').hide();
			$('div[name="pecuarista_desconto_fundo_rural"]').closest('div.layout').next('.layout').hide();
		}
	});

	$('button[name="send_form"]').on('click', function(event) {
		event.preventDefault();
		var form = $(this).closest('form');
		validation = validarFormulario($(this));
		if (validation == 0) {
			var data = new FormData(form[0]);
			$.ajax({
				type: "POST",
				enctype: "multipart/form-data",
				url: "<?= $url_site ?>/modulos/pecuarista/db.php",
				data: data,
				processData: false,
				contentType: false,
				cache: false,
				timeout: 600000,
				success: function(data) {
					if (data.indexOf('sucesso') > -1) {
						var dados = JSON.parse(data);
						$('#modalFeedback').modal('show');
						$('#modalFeedback').find('.modalContent').html('<div class="text-center">' + dados.msg_string + '</div>');
						$("#btn-search").click();
						$("#btnEnviar").hide();
						table.api().ajax.reload();
					} else {
						$('#formError').modal('show');
						if (data.indexOf('Fatal error') > -1) {
							$('#formError').find('.mainModalContent').html('<div class="text-center">Informe o desenvolvedor <br> Erro 0001</div>');
						} else if (data == '') {
							$('#formError').find('.mainModalContent').html('<div class="text-center">' +
								'Erro desconhecido ' +
								'</div>');
						} else {
							var dados = JSON.parse(data);
							$('#formError').find('.mainModalContent').html('<div class="text-center">' + JSON.stringify(dados.error_msg) + '</div>');
						}
					}
				},
				error: function(e) {
					$('#formError').modal('show');
					$('#formError').find('.mainModalContent').html('<div class="text-center">Requisição não foi executada!</div>');
					console.log("ERROR : ", e);
				}
			});
		} else {
			$('body').toast({
				class: 'error',
				position: 'bottom center',
				showIcon: 'exclamation',
				message: 'Um ou mais campos obrigatórios não foram preenchidos corretamente <br> Revise os campos!'
			});
		}
	});
</script>