<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {
				'url': '<?= $url_site . 'modulos/pecuarista/home.ajax.php'; ?>'
			},
			'columns': [{
					title: '<?= Funcao::i18n($t_list, "pecuarista_id"); ?>',
					data: 'pecuarista_id'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_nome"); ?>',
					data: 'pecuarista_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_cpf"); ?>',
					data: 'pecuarista_cpf'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_cnpj"); ?>',
					data: 'pecuarista_cnpj'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_rg"); ?>',
					data: 'pecuarista_rg'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_desconto_fundo_rural"); ?>',
					data: 'pecuarista_desconto_fundo_rural'
				},
				{
					title: '<?= Funcao::i18n($t_list, "pecuarista_deconto_fundo_rural_anexo"); ?>',
					data: 'pecuarista_deconto_fundo_rural_anexo'
				},
				{
					title: '<?= Funcao::i18n($act_list, "action"); ?>',
					className: 'text-center',
					data: null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.pecuarista_id;
						return '<div class="ui buttons">' +
							'<a href="<?= $url_site ?>pecuarista/painel/' + _id + '" class="mini ui basic icon button purple"><i class="desktop icon "></i></a>' +
							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
							'<i class="eye outline icon "></i>' +
							'</button>' +
							'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
							'<i class="edit alternate icon "></i>' +
							'</button>' +
							'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" onclick="modalExcluir(this)" data-id="' + _id + '">' +
							'<i class=\'trash alternate icon\'></i>' +
							'</button>' +
							'</div>'
					}
				}
			],
			"columnDefs": [{
					responsivePriority: 1,
					targets: 0
				},
				{
					responsivePriority: 1,
					targets: 1
				},
				{
					responsivePriority: 1,
					width: '60px',
					targets: -1
				}
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?= $url_site ?>datatables.ptbr.json"
			},
			"order": [
				[1, "asc"]
			]
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
	});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == "new" || action == "edit") {
					$("#btnEnviar").show();
					mainModalTitle('Pecuarista : ' + (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/form.php',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterPecuarista,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('Pecuarista : <?= Funcao::i18n($act_list, "show"); ?>');
					requisicaoPOST({
						'url': '<?= $url_site ?>modulos/pecuarista/detail.php',
						'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterPecuarista,
						'callbackparams': 'fullscreen'
					});
				}
			}
		}).modal('show');
	}

	function afterPecuarista(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}

	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post("<?= $url_site ?>modulos/pecuarista/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso', 'Registro excluido com sucesso!');
			} else {
				toast('erro', 'Erro ao excluir, ação não permitida!');
			}
		});
	}
</script>