<?php require_once ("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
		<?php if (!$action): ?>
			<h1> Ação não permitida </h1>
		<?php else: ?>
			<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
				<input type="hidden" name="action" value="<?= $action; ?>">
				<div class="ui grid fields relaxed stackable margin_bottom_field">
					<input type="hidden" name="usuario_id" value="<?= $data->usuario_id ?? ''; ?>" >

					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"usuario_cpf"); ?> </label>
						<input type="text" maxlength="255"  class=" cpf" name="usuario_cpf" value="<?= $data->usuario_cpf ?? '' ?>" required>
					</div>

					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"usuario_senha"); ?> </label>
						<input type="text" maxlength="255"  class=" " name="usuario_senha" value="<?= $data->usuario_senha ?? '' ?>" required>
					</div>

					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"usuario_nome"); ?> </label>
						<input type="text" maxlength="255"  class=" " name="usuario_nome" value="<?= $data->usuario_nome ?? '' ?>" required>
					</div>

					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"usuario_nivel"); ?> </label>
						<select name="usuario_nivel" class=" " required >
							<option value="">Selecione...</option>
							<option value="Administrador" <?= ($data->usuario_nivel ?? '') == 'Administrador' ? 'selected' : '' ?>>Administrador</option>
							<option value="Usuario" <?= ($data->usuario_nivel ?? '') == 'Usuario' ? 'selected' : '' ?>>Usuario</option>
							<option value="Convidado" <?= ($data->usuario_nivel ?? '') == 'Convidado' ? 'selected' : '' ?>>Convidado</option>
						</select>
					</div>

					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"usuario_status"); ?> </label>
						<select name="usuario_status" class=" " required >
							<option value="">Selecione...</option>
							<option value="Liberado" <?= ($data->usuario_status ?? '') == 'Liberado' ? 'selected' : '' ?>>Liberado</option>
							<option value="Bloqueado" <?= ($data->usuario_status ?? '') == 'Bloqueado' ? 'selected' : '' ?>>Bloqueado</option>
						</select>
					</div>
				</div>
				<button type="button" name="send_form" class="hide"> Gravar Dados</button>
			</form>
		<?php endif ?>
		</div>
	</div>
</div>
<?php require_once ("form_custom_footer.php");?>