<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {'url': '<?=$url_site.'modulos/usuario/home.ajax.php';?>'},
			'columns': [
									{
					title: '<?= Funcao::i18n($t_list,"usuario_id"); ?>',
					data: 'usuario_id'
				},
				{
					title: '<?= Funcao::i18n($t_list,"usuario_cpf"); ?>',
					data: 'usuario_cpf'
				},
				{
					title: '<?= Funcao::i18n($t_list,"usuario_senha"); ?>',
					data: 'usuario_senha'
				},
				{
					title: '<?= Funcao::i18n($t_list,"usuario_nome"); ?>',
					data: 'usuario_nome'
				},
				{
					title: '<?= Funcao::i18n($t_list,"usuario_nivel"); ?>',
					data: 'usuario_nivel'
				},
				{
					title: '<?= Funcao::i18n($t_list,"usuario_status"); ?>',
					data: 'usuario_status'
				},
				{
					title: '<?= Funcao::i18n($act_list,"action"); ?>',
					className: 'text-center',
					data:null,
					sortable: false,
					orderable: false,
					"render": function(data, type, full, meta) {
						var _id = full.usuario_id;
						return '<div class="ui buttons">' +
							
							'<button class="mini ui basic icon button green" data-content="Consultar" onclick="modalSistema(this)" data-id="' + _id + '" data-inverted=""  data-action="show" data-tooltip="Visualizar" data-position="top left">' +
									'<i class="eye outline icon "></i>' +
								'</button>' +
								'<button class="mini ui basic icon button orange" data-content="Alterar" onclick="modalSistema(this)" data-id="' + _id + '"  data-inverted=""  data-action="edit" data-tooltip="Editar" data-position="top center">' +
									'<i class="edit alternate icon "></i>' +
								'</button>' +
								'<button  data-inverted="" data-tooltip="Excluir" data-position="top right" class="excluir mini ui basic icon red button delButton" data-html="<div class=\'ui buttons\'><button onclick=\'del(' + _id + ')\' class=\'ui negative button\'>Sim</button><div class=\'or\' data-text=\'?\'></div><button class=\'ui positive button\' onclick=\'ocultarExcluir()\'>Não</button></div>\">'+
								'<i class=\'trash alternate icon\'></i>'+
									'</button>' +
						'</div>'
					}
				}
			],
			"columnDefs": [
				{ responsivePriority: 1, targets: 0 },
				{ responsivePriority: 1, targets: 1 },
				{ responsivePriority: 1, width: '60px', targets: -1 }			
			],
			autoWidth: false,
			responsive: true,
			"language": {
				"url": "<?=$url_site ?>datatables.ptbr.json"
			},
			"order": [
				[0, "asc"]
			],
			"drawCallback": function () {
	            $(".excluir").popup({on:"click"});
	        }
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
		});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == "new" || action == "edit") {
					$("#btnEnviar").show();
					mainModalTitle('Usuario : '+ (action == 'new' ? '<?= Funcao::i18n($act_list, "new"); ?>' : '<?= Funcao::i18n($act_list, "edit"); ?>'));
					requisicaoPOST({'url': '<?= $url_site ?>modulos/usuario/form.php','campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterUsuario,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('Usuario : <?= Funcao::i18n($act_list, "show"); ?>');
					requisicaoPOST({'url': '<?= $url_site ?>modulos/usuario/detail.php','campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': afterUsuario,
						'callbackparams': 'big'
					});
				}
			}
		}).modal('show');
	}
	function afterUsuario(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}
	function del(del_id) {
		_id = parseInt(del_id);
		$.post("<?=$url_site?>modulos/usuario/delete.php", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == "OK") {
				table.api().ajax.reload();
				toast('sucesso','Registro excluido com sucesso!');
			} else {
				toast('erro','Erro ao excluir, ação não permitida!');
			}
		});
	}

</script>