<?php require_once("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
			<?php if (!$action) : ?>
				<h1> Ação não permitida </h1>
			<?php else : ?>
				<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
					<input type="hidden" name="action" value="<?= $action; ?>">
					<div class="ui grid fields relaxed stackable margin_bottom_field">
						<input type="hidden" name="veiculo_id" value="<?= $data->veiculo_id ?? ''; ?>">

						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "veiculo_tipo"); ?> </label>
							<select name="veiculo_tipo" class=" " required>
								<option value="">Selecione...</option>
								<option value="Truck" <?= ($data->veiculo_tipo ?? '') == 'Truck' ? 'selected' : '' ?>>Truck</option>
								<option value="Carreta 1 Eixo" <?= ($data->veiculo_tipo ?? '') == 'Carreta 1 Eixo' ? 'selected' : '' ?>>Carreta 1 Eixo</option>
								<option value="Carreta 2 Eixos" <?= ($data->veiculo_tipo ?? '') == 'Carreta 2 Eixos' ? 'selected' : '' ?>>Carreta 2 Eixos</option>
								<option value="Carreta 2 Andares" <?= ($data->veiculo_tipo ?? '') == 'Carreta 2 Andares' ? 'selected' : '' ?>>Carreta 2 Andares</option>
							</select>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "veiculo_quantidade_max_abrigada"); ?> </label>
							<input type="text" maxlength="11" class=" number" name="veiculo_quantidade_max_abrigada" value="<?= $data->veiculo_quantidade_max_abrigada ?? '' ?>" required>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "veiculo_placa"); ?> </label>
							<input type="text" maxlength="255" class=" " name="veiculo_placa" value="<?= $data->veiculo_placa ?? '' ?>" required>
						</div>
						<div class="layout ">
							<label> <?= Funcao::i18n($t_list, "veiculo_nome"); ?> </label>
							<input type="text" maxlength="255" class=" " name="veiculo_nome" value="<?= $data->veiculo_nome ?? '' ?>">
						</div>



					</div>
					<button type="button" name="send_form" class="hide"> Gravar Dados</button>
				</form>
			<?php endif ?>
		</div>
	</div>
</div>
<?php require_once("form_custom_footer.php"); ?>