<?php include_once '../autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$locale = 'pt_br';
$validLocale = \PhpOffice\PhpSpreadsheet\Settings::setLocale($locale);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
//Tamanho das Células
$sheet->getColumnDimension('A')->setWidth(60);
$sheet->getColumnDimension('B')->setWidth(20);
$sheet->getColumnDimension('C')->setWidth(30);

// Define o cabeçalho
$sheet->setCellValue('A1', 'Servidor1')
	->getStyle('A1')->getFont()->setBold(true);
$sheet->setCellValue('B1', 'CPF')
	->getStyle('B1')->getFont()->setBold(true);
$sheet->setCellValue('C1', 'Matricula')
	->getStyle('C1')->getFont()->setBold(true);
$sheet->setCellValue('D1', 'Campo Data')
	->getStyle('D1')->getFont()->setBold(true);

//Define os Valores do relatório

$arrayDados = array();
for ($i = 2; $i <= 50; $i++) {
	$arrayDados[] = array(
		'nome' => 'Nome do Servidor ' . $i,
		'cpf' => '000.000.000-00',
		'matricula' => str_pad($i, 6, 0, STR_PAD_LEFT),
		'data' => '2002-05-06'
	);
}

$linha = 2; // Valor inicial da linha
foreach ($arrayDados as $dados) {
	$sheet->setCellValue("A" . $linha, $dados["nome"]);
	$sheet->setCellValue("B" . $linha, $dados["cpf"]);
	$sheet->setCellValue("C" . $linha, $dados["matricula"]);
	$sheet->setCellValue("D" . $linha, $dados["data"]);
	$linha++;
}

// Totalizadores
$sheet->setCellValue("C" . $linha, 'Quantidade de Registros')
	->getStyle("C" . $linha,)->getFont()->setBold(true);
$sheet->setCellValue("D" . $linha, count($arrayDados))
	->getStyle("D" . $linha,)->getFont()->setBold(true);


$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="relatorio_' . date('Ymdhis') . '"');
$writer->save('php://output');
