<?php
$relative_path = '../../';
require_once($relative_path . 'autoload.php');
$ano_inicio = 1994;
$ano_fim = date('Y');


$logo_relatorio = $relative_path . 'imagens/layout/logo_default.png';
$_POST["month"] = 01;
$_POST["year"] = 2023;
$dados_instituto = array();
$dados_instituto["RAZAO_SOCIAL"] = 'INSTITUTO DE TESTE';

$header = '<div style="width:100%;">
    <div style="width:45mm; float:left;">
        <img src="' . $relative_path . 'imagens/client/' . $logo_relatorio . '" width="44mm">
    </div>
    <div style="width:135mm; float:right; text-align: right;margin-top: 3px;">
        <h3>' . $dados_instituto["RAZAO_SOCIAL"] . '</h3>
    </div>    
</div>';


$footer = '
    <div style="width:120px; float:left; margin-top:35px;">
        <img src="' . $relative_path . 'imagens/client/' . $logo_relatorio . '" width="120px">
    </div>  
';

$doc_margin_left = 10;
$doc_margin_right = 10;

$mpdf = new \Mpdf\Mpdf([
    'curlAllowUnsafeSslRequests' => true,
    'mode' => 'utf-8',
    'format' => 'A4-P',
    'orientation' => 'P',
    'margin_left' => $doc_margin_left,
    'margin_right' => $doc_margin_right,
    'margin_top' => 20,
    'margin_bottom' => 20,
    'margin_header' => 8,
    'margin_footer' => 5
]);
$mpdf->showImageErrors = true;
// $mpdf->SetWatermarkText("CONFERÊNCIA");
$mpdf->SetHTMLHeader($header);
$mpdf->SetTitle("Planilha de Calculo");
$mpdf->SetAuthor("GESTÃO FACIL");
$mpdf->showWatermarkText = true;
$mpdf->watermark_font = 'DejaVuSansCondensed';
$mpdf->watermarkTextAlpha = 0.2;
$mpdf->SetDisplayMode('fullpage');
$mpdf->setFooter($footer . '<div style="float:right;">Página {PAGENO} de {nb}</div>');
$mpdf->writeHtml('<link rel="stylesheet" href="' . $url_site . 'vendor/fomantic/ui/dist/semantic.min.css">');
$mpdf->writeHTML('
<style>
    *{
        padding: 0 !important;
        margin: 0 !important;
    }
    th{
        font-size:8px;
        text-align: center;
    }    
    td{
        font-size:8px;
        text-align: center;
        border: 1px solid #cccccc !important;
    }
    .div_tabela{padding: 1px !important;}  
    .text-center{text-align: center !important;}  
}

</style>
');





$obj = array();
for ($ano = $ano_inicio; $ano <= $ano_fim; $ano++) {
    for ($mes = 1; $mes <= 12; $mes++) {
        switch ($mes) {
            case '1':
                $mes_nome = 'Jan';
                break;
            case '2':
                $mes_nome = 'Fev';
                break;
            case '3':
                $mes_nome = 'Mar';
                break;
            case '4':
                $mes_nome = 'Abr';
                break;
            case '5':
                $mes_nome = 'Mai';
                break;
            case '6':
                $mes_nome = 'Jun';
                break;
            case '7':
                $mes_nome = 'Jul';
                break;
            case '7':
                $mes_nome = 'Jul';
                break;
            case '8':
                $mes_nome = 'Ago';
                break;
            case '9':
                $mes_nome = 'Set';
                break;
            case '10':
                $mes_nome = 'Out';
                break;
            case '11':
                $mes_nome = 'Nov';
                break;
            case '12':
                $mes_nome = 'Dez';
                break;
        }
        $obj[] = array(
            'COMPETENCIA' => $mes . '/' . $ano,
            'MES' => $mes_nome,
            'REMUNERACAO' => (rand(1400, 3000)),
            'FATOR ATUAL.' => 0.0003
        );
    }
}

// ob_start();
$maxTablesCols = 3;
switch ($maxTablesCols) {
    case 3:
        $maxPageRows = 4;
        break;
    case 4:
        $maxPageRows = 6;
        break;
    case 5:
        $maxPageRows = 8;
        break;
    default:
        Mensagem::alerta('Erro', 'Padrão incorreto para número de colunas por página');
        exit();
        break;
}

$rowCount = 1;
$maxRows = 12;
$tableNumber = 1;
$numRows = count($obj);
$TablesPerPage = ($maxPageRows * $maxTablesCols);
$doc_width = (((210 - ($doc_margin_left + $doc_margin_right)) / $maxTablesCols) - 2) . 'mm;';
$table =  '<div class="div_tabela" style="width:' . $doc_width . ' float:left;"> <table class="ui table celed red"  style="width:100%";>';
$fecha_table =  "</table></div>";

$abre_tbody = '<tbody>';
$fecha_tbody = '</tbody>';


//MONTA AS TABELAS CONFORME RESULTADOS
$i = 1;
$pagina = 1;
$tabelaCompleta = '';

$tabelaCompleta .= $table . PHP_EOL;
$tabelaCompleta .= '
<thead>
    <tr><th colspan="5"> ' . $ano_inicio . ' </th></tr>
    <tr><th>#</th><th>MÊS</th><th>REMUNERAÇÃO</th><th>FATOR</th><th>ATUALIZADO</th></tr>
</thead>' . PHP_EOL;


$tabelaCompleta .= $abre_tbody . PHP_EOL;

foreach ($obj as $dados) {

    $tabelaCompleta .= "<tr><td>" . str_pad($i++, 3, 0, STR_PAD_LEFT) . "</td>";
    $tabelaCompleta .= "<td style='text-align:center'>" . $dados['MES'] . "</td>";
    $tabelaCompleta .= "<td>" . BRL($dados['REMUNERACAO']) . "</td>";
    $tabelaCompleta .= "<td >";
    $tabelaCompleta .= $dados['FATOR ATUAL.'];
    $tabelaCompleta .= "</td>";
    $tabelaCompleta .= "<td >";
    $tabelaCompleta .= BRL($dados['REMUNERACAO'] + ($dados['REMUNERACAO'] * $dados['FATOR ATUAL.']));
    $tabelaCompleta .= "</td>";
    $tabelaCompleta .= "</tr>";
    if ($rowCount % $maxRows == 0 && $rowCount != $numRows) {
        $tabelaCompleta .= "$fecha_tbody $fecha_table";
        $tabelaCompleta .= "$table ";
        $tabelaCompleta .= '
            <thead>
                <tr><th colspan="5"> ' . ($ano_inicio + $tableNumber) . ' </th></tr>
                <tr><th>#</th><th>MÊS</th><th>REMUNERAÇÃO</th><th>FATOR</th><th>ATUALIZADO</th></tr>
            </thead>' . PHP_EOL;
        $tabelaCompleta .= "$abre_tbody";
        $tableNumber++;
    }
    $rowCount++;
}
$tabelaCompleta .= $fecha_tbody . PHP_EOL;
$tabelaCompleta .= $fecha_table . PHP_EOL;




$mpdf->writeHTML('<hr>
<div style="text-align:center;">
    PLANILHA DE CALCULO: FULANO DE TAL
</div>');


$mpdf->WriteHTML($tabelaCompleta);

$mpdf->WriteHTML('<hr> <div class="text-center">Resumo da Planilha e explicação dos calculos realizados</div>');
$mpdf->WriteHTML('numero de contribuições: ' . $numRows);

ob_clean();
$mpdf->Output('relatorio.pdf', 'I');
