<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title></title>
    <link rel="stylesheet" href="">
    <script>
        function mascara(o, f) {
            v_obj = o
            v_fun = f
            setTimeout("execmascara()", 1)
        }

        function execmascara() {
            v_obj.value = v_fun(v_obj.value);
        }

        function numeros(v) {
            v = v.replace(/\D/g, "")
            return v
        }

        function CNPJ(v) {
            v = v.replace(/\D/g, "") //Remove tudo o que não é dígito
            v = v.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d)/, "$1.$2.$3/$4-$5")
            return v
        }
    </script>
</head>

<body>
    <!--Importando Script Jquery-->
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
    <div class="container">
        <!--Formulário-->
        <div class="jumbotron jumbotron-fluid bg-light">
            <div class="container">
                <h2 class="display-4 text-center">Pesquisa CNPJ</h2>
            </div>
        </div>
        <form id="post">
            <div class="row my-4">
                <div class="col-md-11">
                    <label for="cnpj" class="form-control-label">CNPJ</label>
                    <input id="cnpj" class="form-control" required type="text" maxlength="18" onkeyup="mascara(this,CNPJ)">
                </div>
                <div class="col-md-1">
                    <label for="cnpj" class="form-control-label">Buscar</label>
                    <button type="button" id="buscar" class="btn btn-primary form-control"><strong>-></strong></button>
                </div>
            </div>
            <div class="row mb-5" id="dados" style="display: none">
                <div class="col-md-12">
                    <label for="nome" class="form-control-label">Razão Social</label>
                    <input id="nome" class="form-control" type="text">
                </div>
                <div class="col-md-12">
                    <label for="fantasia" class="form-control-label">Nome Fantasia</label>
                    <input id="fantasia" class="form-control" type="text">
                </div>
                <div class="col-md-12">
                    <label for="atividade" class="form-control-label">Atividade Principal</label>
                    <input id="atividade" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="telefone" class="form-control-label">Telefone</label>
                    <input id="telefone" class="form-control" required type="text">
                </div>
                <div class="col-md-6">
                    <label for="email" class="form-control-label">E-mail</label>
                    <input id="email" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="cep" class="form-control-label">CEP</label>
                    <input id="cep" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="logradouro" class="form-control-label">Logradouro</label>
                    <input id="logradouro" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="numero" class="form-control-label">Número</label>
                    <input id="numero" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="complemento" class="form-control-label">Complemento</label>
                    <input id="complemento" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="bairro" class="form-control-label">Bairro</label>
                    <input id="bairro" class="form-control" type="text">
                </div>
                <div class="col-md-6">
                    <label for="uf" class="form-control-label">Estado</label>
                    <select id="uf" class="form-control">
                        <option value="AC">Acre</option>
                        <option value="AL">Alagoas</option>
                        <option value="AP">Amapá</option>
                        <option value="AM">Amazonas</option>
                        <option value="BA">Bahia</option>
                        <option value="CE">Ceará</option>
                        <option value="DF">Distrito Federal</option>
                        <option value="ES">Espírito Santo</option>
                        <option value="GO">Goiás</option>
                        <option value="MA">Maranhão</option>
                        <option value="MT">Mato Grosso</option>
                        <option value="MS">Mato Grosso do Sul</option>
                        <option value="MG">Minas Gerais</option>
                        <option value="PA">Pará</option>
                        <option value="PB">Paraíba</option>
                        <option value="PR">Paraná</option>
                        <option value="PE">Pernambuco</option>
                        <option value="PI">Piauí</option>
                        <option value="RJ">Rio de Janeiro</option>
                        <option value="RN">Rio Grande do Norte</option>
                        <option value="RS">Rio Grande do Sul</option>
                        <option value="RO">Rondônia</option>
                        <option value="RR">Roraima</option>
                        <option value="SC">Santa Catarina</option>
                        <option value="SP">São Paulo</option>
                        <option value="SE">Sergipe</option>
                        <option value="TO">Tocantins</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label for="bairro" class="form-control-label">Latitude</label>
                    <input id="latitude" class="form-control" type="text" value="<?= $output->estado->sigla ?? null ?>">
                </div>

                <div class="col-md-6">
                    <label for="bairro" class="form-control-label">Longitude</label>
                    <input id="longitude" class="form-control" type="text" value="<?= $output->estado->sigla ?? null ?>">
        </form>
    </div>
    </div>

    <script type="text/javascript">
        $("#buscar").click(function() {
            //Início do Comando AJAX

            var cnpj = $("#cnpj").val();
            var removePontos = cnpj.replace(".", "");
            var removeBarras = removePontos.replace("/", "");
            var number_cnpj = removeBarras.replace("-", "");
            var number_cnpj = number_cnpj.replace(".", "");
            $.ajax({
                //O campo URL diz o caminho de onde virá os dados
                //É importante concatenar o valor digitado no CNPJ
                url: 'cnpj.php?cnpj=' + number_cnpj,
                //Atualização: caso use java, use cnpj.jsp, usando o outro exemplo.
                //Aqui você deve preencher o tipo de dados que será lido,
                //no caso, estamos lendo JSON.
                dataType: 'json',
                //SUCESS é referente a função que será executada caso
                //ele consiga ler a fonte de dados com sucesso.
                //O parâmetro dentro da função se refere ao nome da variável
                //que você vai dar para ler esse objeto.
                success: function(resposta) {
                    //Confere se houve erro e o imprime
                    if (resposta.status == "ERROR") {
                        alert(resposta.message + "\nEste CNPJ não foi encontrado, verifique!");
                        $("#post #nome").focus().select();
                        return false;
                    }

                    $("#post #nome").val(resposta.nome);
                    $("#post #fantasia").val(resposta.fantasia);
                    $("#post #atividade").val(resposta.atividade_principal);
                    $("#post #telefone").val(resposta.telefone);
                    $("#post #email").val(resposta.email);
                    $("#post #logradouro").val(resposta.logradouro);
                    $("#post #complemento").val(resposta.complemento);
                    $("#post #bairro").val(resposta.bairro);
                    $("#post #cidade").val(resposta.municipio);
                    $("#post #uf").val(resposta.uf);
                    $("#post #cep").val(resposta.cep);
                    $("#post #numero").val(resposta.numero);
                    $("#post #latitude").val(resposta.latitude);
                    $("#post #longitude").val(resposta.longitude);
                    $("#dados").show();
                }
            });
        });
    </script>


    <script>
        function getLocal() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(mostrarPosicao, showError);
            } else {
                x.innerHTML = "Geolocalização não é suportada nesse browser.";
            }
        }

        function mostrarPosicao(position) {
            x.innerHTML = "Latitude: " + position.coords.latitude + "<br>Longitude: " + position.coords.longitude;
        }

        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(showPosition, showError);
            } else {
                x.innerHTML = "Geolocalização não é suportada nesse browser.";
            }
        }

        function showPosition(position) {

            lat = $("#latitude").val();
            lon = $("#longitude").val();
            latlon = new google.maps.LatLng(lat, lon)
            mapa = document.getElementById('mapa')
            mapa.style.height = '600px';
            mapa.style.width = '600px';

            var myOptions = {
                center: latlon,
                zoom: 14,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                mapTypeControl: false,
                navigationControlOptions: {
                    style: google.maps.NavigationControlStyle.SMALL
                }
            };
            var map = new google.maps.Map(document.getElementById("mapa"), myOptions);
            var marker = new google.maps.Marker({
                position: latlon,
                map: map,
                title: "Localização"
            });
        }

        function showError(error) {
            switch (error.code) {
                case error.PERMISSION_DENIED:
                    x.innerHTML = "Usuário rejeitou a solicitação de Geolocalização."
                    break;
                case error.POSITION_UNAVAILABLE:
                    x.innerHTML = "Localização indisponível."
                    break;
                    0
                case error.TIMEOUT:
                    x.innerHTML = "O tempo da requisição expirou."
                    break;
                case error.UNKNOWN_ERROR:
                    x.innerHTML = "Algum erro desconhecido aconteceu."
                    break;
            }
        }
    </script>

</body>

</html>