<?php

function validateSearchField($field_var)
{
	try {
		if (preg_match('/^[a-z0-9_]*$/i', $field_var)) {
			return $field_var;
		} else {
			throw new Exception("Houve um erro ao tentar executar a solicitação");
		}
	} catch (Exception $ex) {
		msg("Danger", $ex->getMessage());
		return false;
	}
}

///////////////////// CODE CONSTRUCTORS /////////////////////////////
function relativeLinkConstructor($path_to_save)
{
	$iLink = 0;
	$pathLink = '../';
	$path = explode('/', $path_to_save);

	for ($jPath = 0; $jPath < count($path); $jPath++) {
		$relativeLink = "../";

		$pathLink = $pathLink . $relativeLink;
		$iLink++;
	}

	return $pathLink;
}
/////////////////////////// AJAX OPTIONS (FOLDER IN ROOT) ///////////////////////////////////////////////////

function buildOptionAjax($ClassName, $key)
{
	echo '<?php include_once "../autoload.php";
	$data = new ' . $ClassName . '();
	$key_selected = $_POST["key_selected"] ?? \'\';
	$filtro = $_GET["filtro"];
	$data->or("' . $key[1] . '", $filtro);
	$data->retorno("array");
	$resultado = $data->listar();
	$resposta = new stdClass();
	$resposta->success = true;
	$resposta->results = array();
	foreach($resultado as $linha) {
		$objeto = new stdClass();
		$objeto->value = $linha[0];
		$objeto->name = $linha[1];
		$objeto->text = $linha[1];
		$resposta->results[] = $objeto;
	}
	$json = json_encode($resposta);
	echo $json;
?>';
}
/////////////////////////// HOME ///////////////////////////////////////////////////

function buildHome($path_to_save, $sub_item)
{
	$pathLink = relativeLinkConstructor($path_to_save);
	$caminho = ($sub_item) ? "" : "modulos/$path_to_save/";
	echo '<?php require_once("' . $caminho . 'tradutor.php"); ?>
';
	if (!$sub_item) {
		echo '<?php require_once("' . $caminho . 'home_custom_header.php"); ?>
<div class="ui attached padded segment">
	<table id="listar" class="ui unstackable celed table" style="width:99%">
	</table>
</div>
';
	} else {
		echo '<?php require_once("' . $pathLink . 'autoload.php"); ?>
<table id="listar" class="ui unstackable celed table" style="width:99%"></table>
';
	}
	echo '<?php require_once ("' . $caminho . 'home_custom_footer.php");?>';
}

function buildHomeAjax($ClassName, $key, $path_to_save,  $fields_type, $sub_item)
{
	$pathLink = relativeLinkConstructor($path_to_save);

	$colunas = "";
	for ($i = 0; $i < count($key); $i++) {
		$column = explode('(', $fields_type[$i]);
		$columnType = $column[0];
		switch ($columnType) {
			case "date":
				$colunas .= '		"' . $key[$i] . '" => ConvertDateFromMysql($dados->' . $key[$i] . '),' . PHP_EOL;
				break;
			case "datetime":
				$colunas .= '		"' . $key[$i] . '" => ConvertDatetimeFromMysql($dados->' . $key[$i] . '),' . PHP_EOL;
				break;
			case "file":
				$colunas .= '		"' . $key[$i] . '" => (!is_null($dados->' . $key[$i] . ')) ? "<a target=\'_blank\' href=\'{$url_site}documento.php?id={$dados->' . $key[$i] . '}\'>Abrir</a>" : null,' . PHP_EOL;
				break;
			default:
				$colunas .= '		"' . $key[$i] . '" => $dados->' . $key[$i] . ',' . PHP_EOL;
				break;
		}
	}
	$colunas = substr($colunas, 0, -2);

	echo '<?php require_once ("' . $pathLink . 'autoload.php"); ?>
<?php require_once ("tradutor.php"); ?>
<?php
$objeto = new ' . $ClassName . '();
';
	if ($sub_item) {
		echo '#CONFIGURE A CHAVE ESTRANGEIRA E DELETE ESTA LINHA;' . 'exit()';
		echo '$objeto->and("' . $key[0] . '",$_GET["fk"]);
	';
	}
	echo '$objeto->orderBy("$columnName $columnSortOrder");
$num_resultados = $objeto->contar(0); // total registros
// Ignorando primeira coluna
array_shift($colunas);
// Filtrando pelas demais colunas
foreach($colunas as $coluna){
	$objeto->or($coluna,$searchValue);
}
$num_registros_filtrados = $objeto->contar(); // total registros filtrados
$objeto->limite($limite);
$resultadoPagina = $objeto->listar();

$data = array();
foreach ($resultadoPagina as $key => $dados) {
	$data[] = Funcao::arrayToDataTables($resultadoPagina[$key], $key);
}

$response = array(
    "draw" => intval($draw),
    "recordsTotal" => intval($num_resultados),
    "recordsFiltered" =>  intval($num_registros_filtrados),
    "data" => $data
);
echo json_encode($response);
';
}

function buildHomeCustomHeader($ClassName, $table_name, $path_to_save)
{
	$iLink = 0;
	$pathLink = '';
	$path = explode('/', $path_to_save);
	$site_map = "";

	for ($jPath = 0; $jPath < count($path); $jPath++) {
		if ((count($path) - 1) != $jPath) {
			$site_map .= '	<a class="sitemap" href="<?= $url_site."' . ($pathLink == '' ? '' : $pathLink . '/') . $path[$jPath] . '/home" ?>"> <?= Funcao::i18n($t_list,"' . $path[$iLink] . '"); ?> </a> | ';
			$pathLink = $pathLink . '/' . $path[$jPath];
			$iLink++;
		} else {
			$site_map .= '<?= Funcao::i18n($t_list,"' . $path[$iLink] . '"); ?>';
		}
	}
	echo '
		<div class="ui segment">
			<strong>
				<a class="sitemap" href="<?=$url_site?>/index.php"><i class="fas fa-home"></i></a> | 
				' . $site_map . '
			</strong>

			<a class="ui small button primary right floated sitemap" data-action="new" data-id="0" onclick="modalSistema(this)">
				<i class="fas fa-plus"></i> <?= Funcao::i18n($act_list, "new"); ?>
			</a>
		</div>';
}

function buildPainel($ClassName, $table_name, $path_to_save, $key)
{
	$keyModId = $key[0];
	$iLink = 0;
	$pathLink = '';
	$path = explode('/', $path_to_save);
	$site_map = "";
	for ($jPath = 0; $jPath < count($path); $jPath++) {
		if ((count($path) - 1) != $jPath) {
			$site_map .= '<a class="sitemap" href="<?= $url_site."' . ($pathLink == '' ? '' : $pathLink . '/') . $path[$jPath] . '/home" ?>"> <?= Funcao::i18n($t_list,"' . $path[$iLink] . '"); ?> </a> | 
			';
			$pathLink = $pathLink . '/' . $path[$jPath];
			$iLink++;
		} else {
			$site_map .= '<a class="sitemap" href="<?= $url_site."' . ($pathLink == '' ? '' : $pathLink . '/') . $path[$jPath] . '/home" ?>"> <?= Funcao::i18n($t_list,"' . $path[$iLink] . '"); ?> </a> | 
			';
			$site_map .= '<?=$data->' . $keyModId . '?>';
		}
	}
	echo '
		<?php require_once ("modulos/' . $path_to_save . '/tradutor.php"); ?>
		<?php
		$data = new ' . $ClassName . '();
		$data->pk($url_id);
		$data = $data->consultar();
		?>
		<div class="ui segment">
			<strong>
				<a class="sitemap" href="<?=$url_site?>/index.php"><i class="fas fa-home"></i></a> | 
				' . $site_map . '
			</strong>
			<button id="botao_novo_painel" class="ui right floated primary button" data-action="new" data-id="0" onclick="modalSistema(this)"><i class="fas fa-plus"></i> <?= Funcao::i18n($act_list, "new"); ?></button>

		</div>
		<div class="ui segment">
	<div id="system_tabs" class="ui top attached blue tabular menu">
		<a class="item active" data-module="' . $path_to_save . '/submodulo/home"><i class=" ui icon folder"></i> Submódulo</a>
		<a class="item" data-module="' . $path_to_save . '/submodulo/home"><i class="ui icon bullhorn"></i> Submódulo</a>
	</div>
	<div id="system_tabs_content" class="ui bottom attached tab segment active"></div>
</div>

<script>
	$(document).ready(function() {
		carregarAba();
		$(\'#system_tabs > .item\').on(\'click\', function() {
			$(\'#system_tabs > .item\').removeClass(\'active\');
			$(this).addClass(\'active\');
			carregarAba();
		});
	});
	function carregarAba(){
		var url = \'<?=$url_site?>modulos/\' + $(\'#system_tabs > .item.active\').attr(\'data-module\') + \'.php\';
		var dados = {fk: <?=$url_id?>};
		loadingTab(url, dados);
	}
</script>';
}

function buildHomeCustomFooter($ClassName, $key, $path_to_save, $sub_item, $painel)
{
	$colunas = "";
	for ($i = 0; $i < count($key); $i++) {
		$colunas .= "				{
					title: '<?= Funcao::i18n(\$t_list,\"{$key[$i]}\"); ?>',
					data: '{$key[$i]}'
				}," . PHP_EOL;
	}
	$painelhtml = '';
	if (!$sub_item && $painel) {
		$painelhtml .= "'<a href=\"<?=\$url_site?>$path_to_save/painel/'+_id+'\" class=\"mini ui basic icon button purple\"><i class=\"desktop icon \"></i></a>'+";
	}


	echo "<script>
	var table;
	$(document).ready(function() {
		$.fn.dataTable.ext.errMode = 'none';
		table = $('#listar').on('error.dt', function(e, settings, techNote, message) {
			console.log('Erro encontrado: ', message);
		}).dataTable({
			'processing': true,
			'serverSide': true,
			'pagging': true,
			'serverMethod': 'post',
			'ajax': {";
	if ($sub_item) {
		echo "'url': '<?=\$url_site.'modulos/$path_to_save/home.ajax.php?fk='.\$_POST[\"fk\"];?>'";
	} else {
		echo "'url': '<?=\$url_site.'modulos/$path_to_save/home.ajax.php';?>'";
	}
	echo    "},
			'columns': [
					$colunas				{
					title: '<?= Funcao::i18n(\$act_list,\"action\"); ?>',
					className: 'text-center',
					data:null,
					sortable: false,
					orderable: false,
					\"render\": function(data, type, full, meta) {
						var _id = full.$key[0];
						return '<div class=\"ui buttons\">' +
							$painelhtml
							'<button class=\"mini ui basic icon button green\" data-content=\"Consultar\" onclick=\"modalSistema(this)\" data-id=\"' + _id + '\" data-inverted=\"\"  data-action=\"show\" data-tooltip=\"Visualizar\" data-position=\"top left\">' +
									'<i class=\"eye outline icon \"></i>' +
								'</button>' +
								'<button class=\"mini ui basic icon button orange\" data-content=\"Alterar\" onclick=\"modalSistema(this)\" data-id=\"' + _id + '\"  data-inverted=\"\"  data-action=\"edit\" data-tooltip=\"Editar\" data-position=\"top center\">' +
									'<i class=\"edit alternate icon \"></i>' +
								'</button>' +
								'<button  data-inverted=\"\" data-tooltip=\"Excluir\" data-position=\"top right\" class=\"excluir mini ui basic icon red button delButton\" onclick=\"modalExcluir(this)\" data-id=\"' + _id + '\">'+
								'<i class=\'trash alternate icon\'></i>'+
									'</button>' +
						'</div>'
					}
				}
			],
			\"columnDefs\": [
				{ responsivePriority: 1, targets: 0 },
				{ responsivePriority: 1, targets: 1 },
				{ responsivePriority: 1, width: '60px', targets: -1 }			
			],
			autoWidth: false,
			responsive: true,
			\"language\": {
				\"url\": \"<?=\$url_site ?>datatables.ptbr.json\"
			},
			\"order\": [
				[0, \"asc\"]
			],
			\"drawCallback\": function () {
	            $(\".excluir\").popup({on:\"click\"});
	        }
		});
	});
	$(function() {
		$('tbody tr')
			.mouseover(function() {
				$(this).addClass('over');
			})
			.mouseout(function() {
				$(this).removeClass('over');
			});
		});

	function modalSistema(button) {
		$('#mainModal').modal({
			closable: false,
			onShow: function() {
				var action = button.getAttribute('data-action');
				var id = button.getAttribute('data-id');
				mainModalLoadingStart();
				if (action == \"new\" || action == \"edit\") {
					$(\"#btnEnviar\").show();
					mainModalTitle('$ClassName : '+ (action == 'new' ? '<?= Funcao::i18n(\$act_list, \"new\"); ?>' : '<?= Funcao::i18n(\$act_list, \"edit\"); ?>'));
					requisicaoPOST({";
	if ($sub_item) {
		echo "'url': '<?= \$url_site ?>modulos/$path_to_save/form.php?fk=<?=\$_POST[\"fk\"]?>',";
	} else {
		echo "'url': '<?= \$url_site ?>modulos/$path_to_save/form.php',";
	}
	echo "'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': after$ClassName,
						'callbackparams': 'big'
					});
				} else {
					mainModalTitle('$ClassName : <?= Funcao::i18n(\$act_list, \"show\"); ?>');
					requisicaoPOST({";
	if ($sub_item) {
		echo "'url': '<?= \$url_site ?>modulos/$path_to_save/detail.php?fk=<?=\$_POST[\"fk\"]?>',";
	} else {
		echo "'url': '<?= \$url_site ?>modulos/$path_to_save/detail.php',";
	}
	echo "'campos': {
							id: id,
							action: action
						},
						'conteudo': '#mainModalContent',
						'callback': after$ClassName,
						'callbackparams': 'big'
					});
				}
			}
		}).modal('show');
	}
	
	function after$ClassName(tamanho) {
		mainModalLoadingEnd(tamanho);
		init_plugin_mask();
	}


	function modalExcluir(button) {
		$('.modaldel').modal({
			closable: false,
			onShow: function() {
				var id = button.getAttribute('data-id');
				$('.modaldel').find('.approve').attr('data-id', id);
			}
		}).modal('show');
	}

	function del(button) {
		_id = parseInt(button.getAttribute('data-id'));
		$.post(\"<?=\$url_site?>modulos/$path_to_save/delete.php\", {
			id: _id
		}, function(resultado) {
			if (resultado.trim() == \"OK\") {
				table.api().ajax.reload();
				toast('sucesso','Registro excluido com sucesso!');
			} else {
				toast('erro','Erro ao excluir, ação não permitida!');
			}
		});
	}

</script>";
}


/////////////////////////// END HOME BUILD  ///////////////////////////////////////////////////


/////////////////////////// FORM /////////////////////////////////////////////////////////////
function buildForm($key, $fields_required, $fields_type, $fields_mask, $maxlength)
{
	$inputFields = '';
	for ($i = 0; $i < count($key); $i++) {
		$keyMod = $key[$i] . ' ?? \'\'';
		$keyModSelect = $key[$i];
		$enum = explode('(', $fields_type[$i]);
		$enumType = $enum[0];


		if ($enumType == "enum") {
			$enumOptions = $enum[1];
			$enumOptions = str_replace('(', '', $enumOptions);
			$enumOptions = str_replace(')', '', $enumOptions);
			$enumOptions = str_replace('\'', '', $enumOptions);
			$enumOptions = explode(',', $enumOptions);
			$selEnumOptions = '			<option value="">Selecione...</option>' . PHP_EOL;
			foreach ($enumOptions as $dataEnumOptions) {
				$selEnumOptions .= '							<option value="' . $dataEnumOptions . '" <?= ($data->' . $keyModSelect . ' ?? \'\') == \'' . $dataEnumOptions . '\' ? \'selected\' : \'\' ?>>' . $dataEnumOptions . '</option>' . PHP_EOL;
			}
		}

		if (($enumType != "enum" && $enumType != "foreign")) {
			switch ($fields_type[$i]) {
				case "text":
				case "tel":
				case "number":
				case "float":
					$field = '						<input type="text" maxlength="' . $maxlength[$i] . '"  class=" ' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . ' ?>" ' . $fields_required[$i] . '>';
					break;
				case "email":
					$field = '						<input type="email" class=" ' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . ' ?>" ' . $fields_required[$i] . '>';
					break;
				case "date":
					$field = '						<div class="ui calendar">
							<div class="ui input left icon">
							<i class="calendar icon"></i>
							<input type="text" minlength="10" maxlength="10" class="' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . ' ?>" ' . $fields_required[$i] . '>
							</div>
						</div>';

					break;
				case "datetime":
					$field = '						<input type="text" minlength="16" maxlength="16" class=" ' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= ConvertDatetimeFromMysql($data->' . $keyMod . ') ?>" ' . $fields_required[$i] . '>';
					break;
				case "password":
					$field = '						<input type="password" class=" ' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . ' ?>" ' . $fields_required[$i] . '>';
					break;
				case "file":
					$field = '						<div class="ui file action input ' . $fields_mask[$i] . '">
							<input id="' . $key[$i] . '" name="' . $key[$i] . '" type="file" ' . $fields_required[$i] . '>
							<label for="' . $key[$i] . '" class="ui blue button">
							<i class="file icon"></i>
								Escolha um arquivo
							</label>
						</div>';
					break;
				case "textarea":
					$field = '						<textarea name="' . $key[$i] . '" class=" editor" ' . $fields_required[$i] . '><?= $data->' . $keyMod . '; ?></textarea>';
					break;
				default:
					$field = '						<input type="text" class=" ' . $fields_mask[$i] . '" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . ' ?>" ' . $fields_required[$i] . '>';
					break;
			}
		} else {
			switch ($enumType) {
				case "foreign":
					$field = '						<div id="' . $key[$i] . '" class="ui search selection dropdown">
							<input type="hidden" name="' . $key[$i] . '" value="<?=$data->' . $key[$i] . '?>" ' . $fields_required[$i] . '>
							<?php
							if($data->' . $key[$i] . '!=""){
								echo \'<div class="text">\'.$data->' . $key[$i] . '.\'</div>\';
							}else{
								echo \'<div class="default text">Selecione...</div>\';
							}
							?>
							<i class="dropdown icon"></i>
						</div>';
					break;
				case "enum":
					$field = '						<select name="' . $key[$i] . '" class=" " ' . $fields_required[$i] . ' >
				' . $selEnumOptions . '						</select>';
					break;
			}
		}

		if ($key[$i] == $key[0]) {
			$inputFields .= '					<input type="hidden" name="' . $key[$i] . '" value="<?= $data->' . $keyMod . '; ?>" >' . PHP_EOL;
		} else if ($fields_type[$i] == 'fksubitem') {
			$inputFields .= '					<input type="hidden" name="' . $key[$i] . '" value="<?= $_GET["fk"]; ?>" >' . PHP_EOL;
		} else {

			if ($fields_type[$i] == 'file') {
				$inputFields .= '					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"' . $key[$i] . '"); ?> ' . PHP_EOL .
					'<?php
						if ($action=="edit") {
							echo (!is_null($data->' . $key[$i] . ')) ? ": <a target=\'_blank\' href=\'{$url_site}documento.php?id={$data->' . $key[$i] . '}\'>Abrir arquivo atual</a>" : \' | Sem arquivo\';
						}
						?>' .
					'</label>' . PHP_EOL .
					$field . '
					</div>' . PHP_EOL;
			} else {
				$inputFields .= '
					<div class="layout ">
						<label> <?= Funcao::i18n($t_list,"' . $key[$i] . '"); ?> </label>' . PHP_EOL .
					$field . '
					</div>' . PHP_EOL;
			}
		}
	}

	echo '<?php require_once ("form_custom_header.php"); ?>
<div class="mx-1 mb-2 bg-white rounded rounded-lg">
	<div class="card">
		<div class="card-body card-block mx-3">
		<?php if (!$action): ?>
			<h1> Ação não permitida </h1>
		<?php else: ?>
			<form name="form" method="post" enctype="multipart/form-data" autocomplete="off" class="ui form black segment">
				<input type="hidden" name="action" value="<?= $action; ?>">
				<div class="ui grid fields relaxed stackable margin_bottom_field">
' . $inputFields . '				</div>
				<button type="button" name="send_form" class="hide"> Gravar Dados</button>
			</form>
		<?php endif ?>
		</div>
	</div>
</div>
<?php require_once ("form_custom_footer.php");?>';
}

function buildFormCustomHeader($ClassName, $key, $path_to_save)
{
	$pathLink = relativeLinkConstructor($path_to_save);

	for ($j = 0; $j < count($key); $j++) {
		$keyMod = $key[0];
	};
	echo '<?php require_once ("' . $pathLink . 'autoload.php"); require_once ("tradutor.php");
	$action = $_POST["action"];
	$data = new ' . $ClassName . '();
	$data->pk($_POST["id"]);
	$data = $data->consultar();
?>';
}

function buildFormCustomFooter($ClassName, $key, $fk_key, $path_to_save, $fields_layout)
{
	$fields = '';
	$ajax = '		// AJAX OPTIONS' . PHP_EOL;
	for ($i = 0; $i < count($key); $i++) {
		if ($key[$i] == $key[0]) {
		} else {
			$fields .= '		$(\'[name="' . $key[$i] . '"]\').closest(\'div.layout\').addClass(\'' . $fields_layout[$i] . ' wide field' . '\');' . PHP_EOL;
		}
		if ($fk_key[$i] != "") {
			$keyMod = $key[$i];
			$ajax .= "		$('#{$key[$i]}').dropdown({" . PHP_EOL;
			$ajax .= "			apiSettings: {" . PHP_EOL;
			$ajax .= "				url: '<?= \$url_site ?>/ajax_options/{$fk_key[$i]}.ajax.php?filtro={query}'" . PHP_EOL;
			$ajax .= "			}," . PHP_EOL;
			$ajax .= "			saveRemoteData: false" . PHP_EOL;
			$ajax .= "		})" . PHP_EOL;
		}
	}
	$ajax .=  '		// END AJAX OPTIONS
	sessionStorage.clear();' . PHP_EOL;
	echo '<script>
	$(document).ready(function() {
' . $fields . ' ' . $ajax . '
	// campos required
	adicionarAsteriscos();
});

		$(\'button[name="send_form"]\').on(\'click\', function(event) {
			event.preventDefault();
			var form = $(this).closest(\'form\');	
			validation = validarFormulario($(this));
			if (validation==0) {
		        var data = new FormData(form[0]);
		        $.ajax({
		            type: "POST",
		            enctype: "multipart/form-data",
		            url: "<?=$url_site?>/modulos/' . $path_to_save . '/db.php",
		            data: data,
		            processData: false,
		            contentType: false,
		            cache: false,
		            timeout: 600000,
		            success: function (data) {
		                if (data.indexOf(\'sucesso\') > -1) {
							var dados = JSON.parse(data);
							$(\'#modalFeedback\').modal(\'show\');
							$(\'#modalFeedback\').find(\'.modalContent\').html(\'<div class="text-center">\' + dados.msg_string + \'</div>\');
							$("#btn-search").click();
							$("#btnEnviar").hide();
							table.api().ajax.reload();
		                }else{
							$(\'#formError\').modal(\'show\');
		                	if (data.indexOf(\'Fatal error\') > -1) {
		                		$(\'#formError\').find(\'.mainModalContent\').html(\'<div class="text-center">Informe o desenvolvedor <br> Erro 0001</div>\');
							} else if (data == \'\') {
								$(\'#formError\').find(\'.mainModalContent\').html(\'<div class="text-center">\' +
									\'Erro desconhecido \' +
									\'</div>\');						
							} else {
		                		var dados = JSON.parse(data);
								$(\'#formError\').find(\'.mainModalContent\').html(\'<div class="text-center">\' + JSON.stringify(dados.error_msg) + \'</div>\');
		                	}
		                }
		            },
		            error: function (e) {
						$(\'#formError\').modal(\'show\');					
						$(\'#formError\').find(\'.mainModalContent\').html(\'<div class="text-center">Requisição não foi executada!</div>\');
		                console.log("ERROR : ", e);
		            }
		        });
			}else{
				$(\'body\').toast({
					class: \'error\',
					position: \'bottom center\',
					showIcon: \'exclamation\',
					message: \'Um ou mais campos obrigatórios não foram preenchidos corretamente <br> Revise os campos!\'
				});
			}
		});
</script>
';
}
/////////////////////////// END FORM BUILD ///////////////////////////////////////////////////


/////////////////////////// SHOW ONE ///////////////////////////////////////////////////
function buildDetail($ClassName, $key, $path_to_save, $fields_layout, $fields_type)
{
	$inputFields = '';
	$keyModId = $key[0];
	echo '<?php require_once ("form_custom_header.php"); ?>
<div class="ui segment attached fitted noborder clearing margin_bottom_reg">
	<div class="ui mini labeled button right floated">
		<div class="ui mini black button"> Registro
		</div>
		<a class="ui mini basic black  label">
			<?= $data->' . $keyModId . '; ?>
		</a>
	</div>
</div>

<?php
ob_start(); 
$action = "edit";
include "form.php";
$dados = ob_get_contents(); 
ob_end_clean(); 
echo Regex::converterFormulario($dados);
?>

<?php require_once ("form_custom_footer.php");?>';
}

/////////////////////////// END SHOW ONE BUILD ///////////////////////////////////////////////////


/////////////////////////// MODEL ///////////////////////////////////////////////////////////////
function buildModel($ClassName, $key, $path_to_save, $fields_type)
{
	$pathLink = relativeLinkConstructor($path_to_save);

	$fields = '
	// Todos os dados
	$data->dados($_POST);

	// Dados que precisam de conversões
';
	for ($i = 0; $i < count($key); $i++) {
		$keyMod = $key[$i];

		$column = explode('(', $fields_type[$i]);
		$columnType = $column[0];

		switch ($columnType) {
			case "date":
				$fields .= '	$data->' . $keyMod . ' = ConvertDateToMysql(filter_input(INPUT_POST, "' . $key[$i] . '"));' . PHP_EOL;
				break;
			case "datetime":
				$fields .= '	$data->' . $keyMod . ' = ConvertDatetimeToMysql(filter_input(INPUT_POST, "' . $key[$i] . '"));' . PHP_EOL;
				break;
			case "float":
				$fields .= '	$data->' . $keyMod . ' = ConvertFloatToMysql(filter_input(INPUT_POST, "' . $key[$i] . '"));' . PHP_EOL;
				break;
			case "number":
				$fields .= '	$data->' . $keyMod . ' = ConvertToInt(filter_input(INPUT_POST, "' . $key[$i] . '"));' . PHP_EOL;
				break;
		}
	}

	echo '<?php require_once ("' . $pathLink . 'autoload.php");
	$action = $_POST["action"];
	unset($_POST["action"]);
	$module = "' . $ClassName . '";
	$data = new ' . $ClassName . '();
' . $fields . '
	if ($action == "new") {
	if ($data->cadastrar()) {
		Mensagem::feedback("Sucesso", "Cadastro realizado com sucesso");
	}
	} elseif ($action == "edit") {
		$log_action_module_id = $data->pk();
		if ($data->alterar()) {
			Mensagem::feedback("Sucesso", "Cadastro alterado com sucesso");
		}
	}
?>';
}

function buildDelete($ClassName, $key, $path_to_save)
{
	$keyMod = $key[0];

	$iLink = 0;
	$pathLink = '../';
	$path = explode('/', $path_to_save);

	echo '&lt;?php<br>';
	for ($jPath = 0; $jPath < count($path); $jPath++) {
		$relativeLink = "../";

		$pathLink = $pathLink . $relativeLink;
		$iLink++;
	}

	echo 'include_once "' . $pathLink . 'autoload.php";<br>';
	echo '  $data = new ' . $ClassName . '(); <br>';
	echo '	$' . $key[0] . ' = $_POST["id"] ?? \'\';<br>';
	echo '	$data->pk($' . $key[0] . ');<br>';
	echo '  $old_data = (new ' . $ClassName . ')->pk($' . $key[0] . ' )->listar(0);<br>';
	echo '	if ($data->excluir()) {<br>';
	echo '		echo "OK";<br>';
	echo '	} else {<br>';
	echo '		echo "Falha ao excluir";<br>';
	echo '	};<br>';
	echo '?&gt;<br>';
}



function buildTranslate($key, $path_to_save)
{
	echo '&lt;?php<br>';
	echo '	$t_list = array(<br>';
	echo '// Navigation itens translate<br>';
	$path = explode('/', $path_to_save);
	for ($jPath = 0; $jPath < count($path); $jPath++) {
		echo '		"' . $path[$jPath] . '" => "' . mb_strtoupper($path[$jPath]) . '",<br>';
	}
	echo '// Table Fields Translate<br>';
	for ($i = 0; $i < count($key); $i++) {
		if (($i + 1) < count($key)) {
			echo '		"' . $key[$i] . '" => "' . $key[$i] . '",<br>';
		} else {
			echo '		"' . $key[$i] . '" => "' . $key[$i] . '"<br>';
		}
	}
	echo '	);<br>';
	echo '?&gt;';
}

function buildClass($ClassName, $tableName, $key, $fk)
{
	$class = '<?php
class ' . $ClassName . ' extends Database
{
	public function __construct() {
		$this->tabela = "' . $tableName . '";
		$this->chave_primaria = "' . $key[0] . '";
		$this->order_by = "' . $key[1] . ' ASC";
		$this->join = [';
	foreach ($fk as $indice => $dados) {
		$class .= '
			' . ($indice + 1) . ' => array(
				"tabela" => "' . $dados["REFERENCED_TABLE_NAME"] . '",
				"fk" => "' . $dados["COLUMN_NAME"] . '",
				"pk" => "' . $dados["REFERENCED_COLUMN_NAME"] . '",
				"colunas" => "*"
			),';
	}
	if (count($fk) > 0) {
		$class = substr($class, 0, -1);
	}
	$class .= '
		];
	}
}';
	echo $class;
}
