<!DOCTYPE html>
<html>

<?php
ob_start();
function debug_code($data,  $exit = true)
{
	echo "<pre>";
	print_r($data);
	echo "</pre>";
	if ($exit) {
		exit(0);
	}
}

$database = 'scarceli';
$relative_path_to_save = '../../';
include_once($relative_path_to_save . "/vendor/autoload.php");
include_once($relative_path_to_save . "/classes/framework/configuracao.php");
include_once($relative_path_to_save . "/classes/framework/database.php");
include_once("gen_functions.php");
$passcode = '1234';
$passcheck = $_POST["passcheck"] ?? null;

class CodeGenerator extends Database
{

	function showTables()
	{
		return $this->GeradorConsulta(
			"SHOW TABLES",
			array(),
			false
		);
	}

	function showTableFields($table)
	{
		if (validateSearchField($table)) {
			return $this->GeradorConsulta(
				"DESCRIBE $table
	 	 			",
				array(),
				false
			);
		}
	}

	function getForeignKeys($database, $table)
	{
		if (validateSearchField($table)) {
			return $this->GeradorConsulta(
				"SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME, REFERENCED_TABLE_NAME, REFERENCED_COLUMN_NAME
				 FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
				 WHERE REFERENCED_TABLE_SCHEMA = '$database' AND TABLE_NAME = '$table'",
				array(),
				false
			);
		};
	}

	function showForeignKey($field)
	{
		if (validateSearchField($field)) {
			return $this->GeradorConsulta(
				"SELECT REFERENCED_TABLE_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
	 	 			WHERE
	 	 			    COLUMN_NAME = '$field'
	 	 			",
				array(),
				false
			);
		}
	}

	function getForeignTable($database, $table, $field)
	{
		if (validateSearchField($table)) {
			return $this->GeradorConsulta(
				"SELECT COLUMN_NAME, REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME
					 FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
  					 WHERE REFERENCED_TABLE_SCHEMA = '$database' AND table_name = '$table' AND COLUMN_NAME = '$field'
  					",
				array(),
				false
			);
		}
	}

	static function teste()
	{
		return 'funciona';
	}
}

$code_gen = new CodeGenerator();
$result_tables = $code_gen->showTables();
if (isset($_POST["table"])) {
	$result_fields = $code_gen->showTableFields($_POST["table"]);
}
?>
<!-- Bootstrap Core CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">

<!-- START CSS -->
<link rel="stylesheet" href="style.css">
<!-- END CSS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>

<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>

<div class="my-0 mx-0">
	<div class="card" style="min-height: 600px;">
		<div class="card-header text-right" style="position: fixed; width: 100%; z-index: 999;margin-top: -3px; background-color: #DDDDDD !important;">

		</div>
		<div class="card-body card-block" style="margin-top: 50px; z-index: 0;">
			<?php
			$i = 1;
			if ($passcode == $passcheck) {
			?>
				<div class="row bg-light">
					<div class="col-12" style="border-bottom: 2px solid #000; padding: 20px;margin-bottom: 20px;">

						<form action="" name="gen_fields" method="post">
							<input type="hidden" name="passcheck" value="<?= $passcheck ?>">

							<label for="">Tabela</label>
							<div class="input-group">
								<select name="table" class="selectpicker form-control col-10" data-live-search="true" title="Selecione uma tabela ..." required>
									<option value="">Selecione a tabela</option>
									<?php foreach ($result_tables as $key) : ?>
										<option value="<?= $key[0] ?>"><?= $key[0] ?></option>
									<?php endforeach ?>
								</select>
								<span class="input-group-btn col-2">
									<button type="submit" class="btn btn-primary form-control">Prosseguir</button>
								</span>
							</div>
						</form>
					</div>
				</div>
				<?php if (isset($_POST["table"])) : ?>

					<form action="" name="create_code" method="post">
						<input type="hidden" name="tableName" value="<?= $_POST["table"] ?>">
						<input type="hidden" name="generateCodes" value="yes">
						<input type="hidden" name="passcheck" value="<?= $passcheck ?>">

						<div class="row">
							<?php foreach ($result_fields as $table_fields) : ?>
								<div class="col-lg-4 mb-3">
									<label>Campo <?= $i ?></label>
									<input type="search" class="form-control" name="field_generated[]" value="<?= $table_fields["Field"] ?>" readonly>
								</div>
								<?php
								$foreign_table = "";

								if ($table_fields["Key"] == "MUL") {
									$data_fk = $code_gen->getForeignTable($database, $_POST["table"], $table_fields["Field"]);
									$foreign_table = $data_fk[0]["REFERENCED_TABLE_NAME"];
								}
								?>
								<div class="col-lg-4 mb-3">
									<label>Tabela estrangeira</label>
									<input type="search" class="form-control" name="field_fk[]" value="<?= $foreign_table ?>" readonly>
								</div>
								<div class="col-lg-4 mb-3">
									<?php
									$type = explode("(", $table_fields["Type"]);
									$length = $type[1] ?? null;
									$length = explode(",", $length);
									$length = str_replace(')', '', $length[0]);
									$type = $type[0];
									//print_r($type);
									?>
									<label>Quantidade Caracteres</label>
									<input type="search" class="form-control" name="maxlength[]" value="<?= $type != 'enum' ? $length : '' ?>" readonly>
								</div>

								<div class="col-lg-3 mb-3">
									<label>Obrigatório</label>
									<select name="field_required[]" class="form-control">
										<option value="">Não</option>
										<option value="required" <?= $table_fields["Null"] == 'NO' ? 'selected' : '' ?>>Sim</option>
									</select>
								</div>

								<div class="col-lg-3 mb-3">
									<label>
										Tipo: <?= $type == 'enum' ? strtoupper($type) : strtoupper($table_fields["Type"]) ?> <?= $table_fields["Key"] == "PRI" ? '<span class="text-danger"> | PK</span>' : '' ?>
									</label>
									<select name="field_type[]" class="form-control">
										<option value="text" <?= $type == 'varchar' ? 'selected' : '' ?>>Texto</option>
										<option value="email">Email</option>
										<option value="tel">Telefone</option>
										<option value="password">Senha</option>
										<option value="hidden" <?= $table_fields["Key"] == "PRI" ? 'selected' : '' ?>>Invisivel</option>
										<option value="select">Seleção</option>
										<option value="<?= $table_fields["Type"] ?>" <?= $type == 'enum' ? 'selected' : '' ?>>Enum</option>
										<option value="textarea" <?= $type == 'text' || $type == 'longtext' ? 'selected' : '' ?>>Area de Texto</option>
										<option value="file" <?= $table_fields["Type"] == 'varchar(149)' ? 'selected' : '' ?>>Arquivo</option>
										<option value="number" <?= $type == 'int' && $table_fields["Key"] != "PRI" && $table_fields["Key"] != "MUL" ? 'selected' : '' ?>>Numérico</option>
										<option value="float" <?= $type == 'float' || $type == 'decimal' ? 'selected' : '' ?>>Decimal</option>
										<option value="date" <?= $type == 'date' ? 'selected' : '' ?>>Data</option>
										<option value="datetime" <?= $type == 'datetime' || $type == 'timestamp' ? 'selected' : '' ?>>Data e Hora</option>
										<option value="foreign" <?= $table_fields["Key"] == "MUL" ? 'selected' : '' ?>>Chave Estrangeira</option>
										<option value="fksubitem">FK Subitem</option>
									</select>
								</div>

								<div class="col-lg-3 mb-3">
									<label>Tratamento de dado</label>
									<select name="field_mask[]" class="form-control">
										<option value="">Sem Tratamento</option>
										<option value="editor" <?= $type == 'text' || $type == 'longtext' ? 'selected' : '' ?>>Texto (editor)</option>
										<option value="date" <?= $type == 'date' ? 'selected' : '' ?>>Data</option>
										<option value="time" <?= strpos($table_fields["Field"], 'hour') || strpos($table_fields["Field"], 'hora') ? 'selected' : '' ?>>Hora</option>
										<option value="date_time" <?= $type == 'datetime' ? 'selected' : '' ?>>Data e Hora</option>
										<option value="phone" <?= strpos($table_fields["Field"], 'phone') || strpos($table_fields["Field"], 'telefone') ? 'selected' : '' ?>>Telefone</option>
										<option value="cep" <?= strpos($table_fields["Field"], 'cep') ? 'selected' : '' ?>>CEP</option>
										<option value="cpf" <?= strpos($table_fields["Field"], 'cpf') ? 'selected' : '' ?>>CPF</option>
										<option value="cnpj" <?= strpos($table_fields["Field"], 'cnpj') ? 'selected' : '' ?>>CNPJ</option>
										<option value="money" <?= $type == 'float' || $type == 'decimal' ? 'selected' : '' ?>>Moeda(R$)</option>
										<option value="number" <?= $type == 'int' && !strpos($table_fields["Field"], 'cnpj') && !strpos($table_fields["Field"], 'cpf') ? 'selected' : '' ?>>Numeral</option>
										<option value="percent" <?= strpos($table_fields["Field"], 'percent') ? 'selected' : '' ?>>Porcentagem</option>
										<option value="ipv4" <?= strpos($table_fields["Field"], 'ipv4') ? 'selected' : '' ?>>IPv4</option>
									</select>
								</div>

								<div class="col-lg-3 mb-3 pb-3">
									<label>Layout</label>
									<select name="field_layout[]" class="form-control">
										<option value="one">01 coluna</option>
										<option value="two">02 colunas</option>
										<option value="three">03 colunas</option>
										<option value="four">04 colunas</option>
										<option value="five">05 colunas</option>
										<option value="six">06 colunas</option>
										<option value="seven">07 colunas</option>
										<option value="eight" <?= $type != 'text' ? 'selected' : '' ?>>08 colunas</option>
										<option value="nine">09 colunas</option>
										<option value="teen">10 colunas</option>
										<option value="eleven">11 colunas</option>
										<option value="twelve">12 colunas</option>
										<option value="thirteen">13 colunas</option>
										<option value="fourteen">14 colunas</option>
										<option value="fifteen">15 colunas</option>
										<option value="sixteen" <?= $type == 'text' || $type == 'longtext' || $table_fields["Type"] == 'varchar(50)' ? 'selected' : '' ?>>16 colunas</option>
									</select>
								</div>
								<div class="col-12">
									<hr>
								</div>
								<?php $i++ ?>
							<?php endforeach ?>


							<div class="col-12 mt-3">
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									Deseja criar os arquivos?
									<label class="switch ">
										<input type="checkbox" name="create_pages" id="create_file" class="primary" onchange="check_create_file();">
										<span class="slider"></span>

									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0 path_box" style="display: none">
									Layout Subitem?
									<label class="switch ">
										<input type="checkbox" name="create_sub_item" class="warning">
										<span class="slider"></span>
									</label>
								</li>
								<li class="list-group-item float-left col-md-6 p-1 path_box" style="display: none">
									<div class="row">
										<div class="col-3 pl-4 pt-1"><b>modulos/</b> </div>
										<div class="col-9"><input type="search" class="form-control" id="path_to_save" name="path_to_save"></div>
									</div>
								</li>
							</div>

							<div class="col-12 mt-3 path_box" style="display: none">
								<div class="col-12 mt-3 mb-4 text-center text-primary border-top border-bottom border-primary">
									<h4>Selecione os componentes</h4>
								</div>
								<li class="list-group-item col-md-3 offset-md-9 float-left pt-1 pb-0 mb-4">
									<div class="float-left mt-1 pt-1">TODOS</div>
									<label class="switch  mt-1">
										<input type="checkbox" class="danger" id="checkCreateAll">
										<span class="slider round"></span>
									</label>
								</li>

								<li class="list-group-item col-md-3 offset-md-9 float-left pt-1 pb-0 mb-4 bg-danger">
									<div class="float-left mt-1 pt-1">Sobrescrever</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="sobrescrever" class="warning">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Home</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_home" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Painel</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_painel" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Formulario</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_form" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Model</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_model" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Detalhar</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_detail" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Classe</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_class" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Tradutor</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_translate" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
								<li class="list-group-item col-md-3 float-left pt-1 pb-0">
									<div class="float-left mt-1 pt-1">Excluir</div>
									<label class="switch  mt-1">
										<input type="checkbox" name="create_delete" class="warning createArchive">
										<span class="slider round"></span>
									</label>
								</li>
							</div>
							<div class="col-xl-12 mt-5 path_box" style="display: none">
								<h1 class="text-danger text-center">Atenção! Caso haja arquivos criados eles serão sobrescritos!!! </h1>
							</div>
							<br>
							<div class="text-center col-12">
								<button type="submit" class="btn btn-primary btn-lg my-3">Gerar Códigos</button>
							</div>
					</form>
				<?php endif ?>
		</div>

		<br>
		<?php
				$gen_codes = $_POST['generateCodes'] ?? null;
				$sobrescrever_arquivos = false;
				if (isset($_POST['sobrescrever'])) {
					$sobrescrever_arquivos = true;
				}
				if ($gen_codes == 'yes') {
					if ($_POST) {

						$fields_generated = $_POST["field_generated"];
						$fields_fk = $_POST["field_fk"];
						$fields_required = $_POST["field_required"];
						$fields_type = $_POST["field_type"];
						$fields_mask = $_POST["field_mask"];
						$fields_layout = $_POST["field_layout"];
						$tableName = $_POST["tableName"];
						$maxlength = $_POST["maxlength"];
						$sub_item = $_POST["create_sub_item"] ?? null;

						// echo '<pre>';
						// print_r($fields_type);
						// exit();


						$ClassName = str_replace("_", " ", $_POST["tableName"]);
						$ClassName = ucwords($ClassName);
						$ClassName = str_replace(" ", "", $ClassName);

						$path_to_save = strtolower($_POST['path_to_save']) ?? null;

						if (isset($_POST['create_pages']) && !is_null($path_to_save)) {
							if (!is_dir($relative_path_to_save . 'modulos/' . $path_to_save)) {
								mkdir($relative_path_to_save . 'modulos/' . $path_to_save,  0777, true);
							}

							if (!is_dir($relative_path_to_save . 'ajax_options/')) {
								mkdir($relative_path_to_save . 'ajax_options/',  0777, true);
							}

							if (!file_exists($relative_path_to_save . 'ajax_options/' . $tableName . '.ajax.php') || $sobrescrever_arquivos) {
								ob_start();
								buildOptionAjax($ClassName, $fields_generated);
								$form_file = ob_get_contents();
								ob_end_clean();
								file_put_contents($relative_path_to_save . 'ajax_options/' . $tableName . '.ajax.php', $form_file);
							}

							if (!is_dir($relative_path_to_save . 'files/' . $tableName)) {
								mkdir($relative_path_to_save . 'files/' . $tableName,  0777, true);
							}

							if (isset($_POST['create_translate'])) {
								// TRANSLATE FILE CREATE
								ob_start();
								buildTranslate($fields_generated, $path_to_save);
								$translate_file = ob_get_contents();
								ob_end_clean();
								$translate_file = str_replace('&lt;', '<', $translate_file);
								$translate_file = str_replace('&gt;', '>', $translate_file);
								$translate_file = str_replace('<br>', PHP_EOL, $translate_file);
								if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/tradutor.php')) {
									file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/tradutor.php', $translate_file);
								}
							}

							if (isset($_POST['create_delete'])) {
								// DELETE FILE CREATE
								ob_start();
								buildDelete($ClassName, $fields_generated, $path_to_save);
								$delete_file = ob_get_contents();
								ob_end_clean();
								$delete_file = str_replace('&lt;', '<', $delete_file);
								$delete_file = str_replace('&gt;', '>', $delete_file);
								$delete_file = str_replace('<br>', PHP_EOL, $delete_file);
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/delete.php', $delete_file);
							}

							if (isset($_POST['create_form'])) {

								if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/form_custom_header.php')  || $sobrescrever_arquivos) {
									ob_start();
									buildFormCustomHeader($ClassName, $fields_generated, $path_to_save);
									$form_file = ob_get_contents();
									ob_end_clean();
									file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/form_custom_header.php', $form_file);
								}

								if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/form_custom_footer.php')  || $sobrescrever_arquivos) {
									ob_start();
									buildFormCustomFooter($ClassName, $fields_generated, $fields_fk, $path_to_save, $fields_layout);
									$form_file = ob_get_contents();
									ob_end_clean();
									file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/form_custom_footer.php', $form_file);
								}
								// FORM FILE CREATE
								ob_start();
								buildForm($fields_generated, $fields_required, $fields_type, $fields_mask, $maxlength);
								$form_file = ob_get_contents();
								ob_end_clean();
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/form.php', $form_file);
							}

							if (isset($_POST['create_model'])) {
								// MODEL FILE CREATE
								ob_start();
								buildModel($ClassName, $fields_generated, $path_to_save, $fields_type);
								$model_file = ob_get_contents();
								ob_end_clean();
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/db.php', $model_file);
							}

							if (isset($_POST['create_painel'])) {
								if (!$sub_item) {
									//criar aqui
									if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/painel.php')) {
										ob_start();
										buildPainel($ClassName, $tableName, $path_to_save, $fields_generated);
										$form_file = ob_get_contents();
										ob_end_clean();
										file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/painel.php', $form_file);
									}
								}
							}

							if (isset($_POST['create_home'])) {
								// VIEW ALL (HOME) FILE CREATE
								if (!$sub_item) {
									if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/home_custom_header.php')) {
										ob_start();
										buildHomeCustomHeader($ClassName, $tableName, $path_to_save);
										$form_file = ob_get_contents();
										ob_end_clean();
										file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/home_custom_header.php', $form_file);
									}
								}

								if (!file_exists($relative_path_to_save . 'modulos/' . $path_to_save . '/home_custom_footer.php')  || $sobrescrever_arquivos) {
									ob_start();
									buildHomeCustomFooter($ClassName, $fields_generated, $path_to_save, $sub_item, $_POST['create_painel'] ?? null);
									$form_file = ob_get_contents();
									ob_end_clean();
									file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/home_custom_footer.php', $form_file);
								}

								ob_start();
								buildHome($path_to_save, $sub_item);
								$home_file = ob_get_contents();
								ob_end_clean();
								$home_file = str_replace('<br>', PHP_EOL, $home_file);
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/home.php', $home_file);
								// VIEW ALL (HOME AJAX) FILE CREATE
								ob_start();
								buildHomeAjax($ClassName, $fields_generated, $path_to_save,  $fields_type, $sub_item);
								$home_ajax_file = ob_get_contents();
								ob_end_clean();
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/home.ajax.php', $home_ajax_file);
							}

							if (isset($_POST['create_detail'])) {
								ob_start();
								buildDetail($ClassName, $fields_generated, $path_to_save, $fields_layout, $fields_type);
								$detail_ajax_file = ob_get_contents();
								ob_end_clean();
								file_put_contents($relative_path_to_save . 'modulos/' . $path_to_save . '/detail.php', $detail_ajax_file);
							}
							if (!file_exists($relative_path_to_save . 'classes/tabelas/' . strtolower($ClassName) . '.php')  || $sobrescrever_arquivos) {
								if (isset($_POST['create_class'])) {
									$fk = $code_gen->getForeignKeys($database, $_POST["tableName"]);
									// CLASS FILE CREATE
									ob_start();
									buildClass($ClassName, $tableName, $fields_generated, $fk);
									$class_file = ob_get_contents();
									ob_end_clean();
									file_put_contents($relative_path_to_save . 'classes/tabelas/' . strtolower($ClassName) . '.php', $class_file);
								}
							}
						}
					}
		?>


			<div class="text-center"><button type="button" class="btn btn-lg btn-warning mb-5" id="showCode">MOSTRAR CODIGO</button></div>
			<div id="showCodeDetails" style="display: none">

				<div class="row">
					<div style="width:100% !important; ">
						<nav id='panel'>
							<div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
								<a class="nav-item nav-link" data-toggle="tab" href="#pills-class" role="tab" aria-controls="nav-profile" aria-selected="false">
									Controller (Class)
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#pills-model" role="tab" aria-controls="nav-profile" aria-selected="false">
									Model (db)
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#pills-form" role="tab" aria-controls="nav-profile" aria-selected="false">
									Form
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#home" role="tab" aria-controls="nav-profile" aria-selected="false">
									Home
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#home_header" role="tab" aria-controls="nav-profile" aria-selected="false">
									Home Header
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#home_footer" role="tab" aria-controls="nav-profile" aria-selected="false">
									Home Footer
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#home_ajax" role="tab" aria-controls="nav-profile" aria-selected="false">
									Home Ajax
								</a>
								<a class="nav-item nav-link" data-toggle="tab" href="#detail" role="tab" aria-controls="nav-profile" aria-selected="false">
									Detail
								</a>
							</div>
						</nav>
						<?php
						function dumpCodigo($codigo)
						{
							echo '<pre>';
							echo htmlspecialchars($codigo, ENT_QUOTES);
							echo '</pre>';
						}
						?>
						<div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
							<div style="position: relative" class="tab-pane fade show active" id="content_panel" role="tabpanel">
								<div style="position: absolute;top:50px;" class="tab-pane fade show active" id="pills-form" role="tabpanel">
									<?php
									ob_start();
									buildForm($fields_generated, $fields_required, $fields_type, $fields_mask, $maxlength);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="pills-model" role="tabpanel">
									<?php
									ob_start();
									buildModel($ClassName, $fields_generated, $path_to_save, $fields_type);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="home" role="tabpanel">
									<?php
									ob_start();
									buildHome($ClassName, $fields_generated, $path_to_save);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="home_ajax" role="tabpanel">
									<?php
									ob_start();
									buildHomeAjax($ClassName, $fields_generated, $path_to_save,  $fields_type, $sub_item);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="home_footer" role="tabpanel">
									<?php
									$create_painel = $_POST['create_painel'] ?? false;
									ob_start();
									buildHomeCustomFooter($ClassName, $fields_generated, $path_to_save, $sub_item, $create_painel);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="home_header" role="tabpanel">
									<?php
									if (!$sub_item) {
										ob_start();
										buildHomeCustomHeader($ClassName, $fields_generated, $path_to_save);
										$form_file = ob_get_contents();
										ob_end_clean();
										dumpCodigo($form_file);
									}
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="detail" role="tabpanel">
									<?php
									ob_start();
									buildDetail($ClassName, $fields_generated, $path_to_save, $fields_layout, $fields_type);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
								<div style="position: absolute;top:50px;" class="tab-pane fade" id="pills-class" role="tabpanel">
									<?php
									$fk = $code_gen->getForeignKeys($database, $_POST["tableName"]);
									ob_start();
									buildClass($ClassName, $tableName, $fields_generated, $fk);
									$form_file = ob_get_contents();
									ob_end_clean();
									dumpCodigo($form_file);
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>

		<style type="text/css">
			nav#panel>.nav.nav-tabs {

				border: none;
				color: #fff;
				background: #32539D;
				border-radius: 0;
				margin-top: -10px;
			}

			nav#panel>div a.nav-item.nav-link {
				border: none;
				padding: 18px 25px;
				color: #fff;
				background: #8E8E8E;
				border-radius: 0;
			}

			nav#panel>div a.nav-item.nav-link.active {
				border: none;
				padding: 18px 25px;
				color: #fff;
				background: #ce584b;
				border-radius: 0;
			}

			.tab-pane {
				width: 100% !important
			}

			.tab-content {
				background: #fdfdfd;
				border: 1px solid #ddd;
				border-top: 5px solid #ce584b;
				border-bottom: 5px solid #ce584b;
				padding: 30px 25px !important;
				margin-bottom: -20px;
			}

			nav#panel>div a.nav-item.nav-link:hover:not(.active),
			nav#panel>div a.nav-item.nav-link:focus:not(.active) {
				border: none;
				background: #d97d73;
				color: #fff;
				border-radius: 0;
				transition: background 0.20s linear;
			}

			.bootstrap-select {
				border: 1px solid #ced4da !important;
				-webkit-border-radius: 5px !important;
				-moz-border-radius: 5px !important;
				border-radius: 5px !important;

			}

			.dropdown-menu {
				z-index: 999 !important;
			}
		</style>

		<script>
			$('#showCode').click(function(event) {
				$('#showCodeDetails').toggle('show');
				$(this).text(function(index, text) {
					return text === "MOSTRAR CODIGO" ? "ESCONDER CODIGO" : "MOSTRAR CODIGO";
				})
			});

			$(document).ready(function() {
				$("#create_file").prop('checked', false);
				$(".createArchive").prop('checked', false);
				$('#checkCreateAll').prop('checked', false);
				$('select').selectpicker({
					liveSearch: true,
					width: '100%',
					maxOptions: 5,
					liveSearchNormalize: true
				});
			});

			function check_create_file(id) {
				if ($("#create_file").is(':checked')) {
					$('[name="create_home_sub_item"]').prop('checked', false);
					$(".path_box").show(600);
				} else {
					$(".path_box").hide(600);
				}
			}


			$('#checkCreateAll').on('change', function(event) {
				event.preventDefault();
				if ($(this).is(':checked')) {
					$(".createArchive").prop('checked', true);
				} else {
					$(".createArchive").prop('checked', false);
				}
			});
			$('.createArchive').on('change', function(event) {
				event.preventDefault();
				if ($(this).is(':checked')) {
					var countCheckbox = 0;
					$('.createArchive').each(function() {
						if (!$(this).is(':checked')) {
							return false;
						} else {
							countCheckbox++;
						}
					});

					if (countCheckbox == $('.createArchive').length) {
						$('#checkCreateAll').prop('checked', true);
					}
				} else {
					$('#checkCreateAll').prop('checked', false);
				}
			});
		</script>
	</div>
</div>
<?php } else { ?>
	<form action="" method="post" accept-charset="utf-8" autocomplete="off">
		<div class="row bg-light text-center" style="width: 400px; margin: 0 auto">
			<div class="col-lg-12">
				<input type="hidden" name="passcode" value="<?= $passcode ?>">
				<label for="">Digite sua palavra de segurança</label>
				<input type="password" class="form-control" name="passcheck">
				<div class="text-center col-12">
					<button type="submit" class="btn btn-primary btn-md my-3">Acessar gerador</button>
				</div>
			</div>
	</form>
<?php } ?>

</html>